/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.google.refine.RefineTest;
import com.google.refine.expr.ParsingException;
import org.testng.annotations.Test;

public class UniquesTests
extends RefineTest {
    @Test
    public void uniquesJsonArray() throws ParsingException {
        String[] test = new String[]{"'{a:[2,1,1,3]}'.parseJson().a.uniques().toString()", "[2, 1, 3]"};
        this.parseEval(bindings, test);
        String[] test1 = new String[]{"'[2,2,null,null,3,3]'.parseJson().uniques().toString()", "[2, null, 3]"};
        this.parseEval(bindings, test1);
    }

    @Test
    public void uniquesArray() throws ParsingException {
        String[] test = new String[]{"[2,1,1,3].uniques().toString()", "[2, 1, 3]"};
        this.parseEval(bindings, test);
        String[] test1 = new String[]{"[2,2,null,null,3,3,3].uniques().toString()", "[2, null, 3]"};
        this.parseEval(bindings, test1);
        String[] test2 = new String[]{"['z','b','c','c','a'].uniques().toString()", "[z, b, c, a]"};
        this.parseEval(bindings, test2);
        String[] test3 = new String[]{"['z','z',null,'c','a'].uniques().toString()", "[z, null, c, a]"};
        this.parseEval(bindings, test3);
        String[] test4 = new String[]{"[toDate(2020), '2018-03-02'.toDate(), toDate(2020)].uniques().toString()", "[2020-01-01T00:00Z, 2018-03-02T00:00Z]"};
        this.parseEval(bindings, test4);
        String[] test5 = new String[]{"[null,null,null].uniques().toString()", "[null]"};
        this.parseEval(bindings, test5);
    }

    @Test
    public void uniquesMixedArray() throws ParsingException {
        String[] test = new String[]{"[2,1.0,3,1.0].uniques().toString()", "[2, 1.0, 3]"};
        this.parseEval(bindings, test);
        String[] test1 = new String[]{"[2,'a',3,3,'a'].uniques().toString()", "[2, a, 3]"};
        this.parseEval(bindings, test1);
    }
}

