/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.booleans;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class BooleanTests
extends RefineTest {
    private static String[][] TRUTH_TABLE = new String[][]{{"and", "true", "true", "true", "true"}, {"and", "false", "false", "false", "false"}, {"and", "true", "false", "false", "false"}, {"and", "false", "true", "true", "false"}, {"or", "true", "true", "true", "true"}, {"or", "false", "false", "false", "false"}, {"or", "true", "false", "false", "true"}, {"or", "false", "true", "true", "true"}, {"xor", "true", "true", "true", "false"}, {"xor", "false", "false", "false", "false"}, {"xor", "true", "false", "false", "true"}, {"xor", "false", "true", "false", "true"}};

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testInvalidParams() {
        for (String op : new String[]{"and", "or", "xor"}) {
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, new Object[0]) instanceof EvalError));
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, Boolean.TRUE, 1) instanceof EvalError));
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, 1, Boolean.TRUE) instanceof EvalError));
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, Boolean.TRUE, "foo") instanceof EvalError));
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, "foo", Boolean.TRUE) instanceof EvalError));
            Assert.assertTrue((boolean)(BooleanTests.invoke(op, Boolean.TRUE) instanceof EvalError));
        }
        String op = "not";
        Assert.assertTrue((boolean)(BooleanTests.invoke(op, new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(BooleanTests.invoke(op, Boolean.TRUE, Boolean.TRUE) instanceof EvalError));
        Assert.assertTrue((boolean)(BooleanTests.invoke(op, 1) instanceof EvalError));
        Assert.assertTrue((boolean)(BooleanTests.invoke(op, "foo") instanceof EvalError));
    }

    @Test
    public void testBinary() {
        for (String[] test : TRUTH_TABLE) {
            String operator = test[0];
            Boolean op1 = Boolean.valueOf(test[1]);
            Boolean op2 = Boolean.valueOf(test[2]);
            Boolean op3 = Boolean.valueOf(test[3]);
            Boolean result = Boolean.valueOf(test[4]);
            Assert.assertEquals((Object)BooleanTests.invoke(operator, op1, op2, op3), (Object)result);
        }
        Assert.assertEquals((Object)BooleanTests.invoke("not", Boolean.TRUE), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)BooleanTests.invoke("not", Boolean.FALSE), (Object)Boolean.TRUE);
    }
}

