/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.date;

import com.google.refine.RefineTest;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DatePartTests
extends RefineTest {
    static Properties bindings;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HH:mm:ss.SSSSSSSSSX");

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testOffsetDateTimeDatePart() {
        OffsetDateTime source = OffsetDateTime.parse("20180430-23:55:44.000789000Z", this.formatter);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "hours"), (Object)23);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "hour"), (Object)23);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "h"), (Object)23);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "minutes"), (Object)55);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "minute"), (Object)55);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "min"), (Object)55);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "seconds"), (Object)44);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "sec"), (Object)44);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "s"), (Object)44);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "milliseconds"), (Object)789);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "ms"), (Object)789);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "S"), (Object)789);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "nanos"), (Object)789000);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "nano"), (Object)789000);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "n"), (Object)789000);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "years"), (Object)2018);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "year"), (Object)2018);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "months"), (Object)4);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "month"), (Object)4);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "weeks"), (Object)5);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "week"), (Object)5);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "w"), (Object)5);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "days"), (Object)30);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "day"), (Object)30);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "d"), (Object)30);
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "weekday"), (Object)"MONDAY");
        Assert.assertEquals((Object)DatePartTests.invoke("datePart", source, "time"), (Object)1525132544000L);
    }

    private Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        return calendar;
    }
}

