/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.html;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ParseHtmlTests
extends RefineTest {
    static Properties bindings;
    static String h;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testParseHtml() {
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("parseHtml", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("parseHtml", "h") instanceof Document));
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("select", Jsoup.parse((String)h), "p") instanceof Elements));
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("innerHtml", Jsoup.parse((String)h).select("p").first()) instanceof String));
        Assert.assertEquals((Object)ParseHtmlTests.invoke("innerHtml", Jsoup.parse((String)h).select("p").first()), (Object)"para1 <strong>strong text</strong>");
        Assert.assertEquals((Object)ParseHtmlTests.invoke("htmlAttr", Jsoup.parse((String)h).select("div").first(), "class"), (Object)"class1");
        Assert.assertEquals((Object)ParseHtmlTests.invoke("htmlText", Jsoup.parse((String)h).select("div").first()), (Object)"para1 strong text para2");
        Assert.assertEquals((Object)ParseHtmlTests.invoke("ownText", Jsoup.parse((String)h).select("p").first()), (Object)"para1");
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("wholeText", Jsoup.parse((String)h).select("div.commentthread_comment_text").first()) instanceof String));
        Assert.assertEquals((Object)ParseHtmlTests.invoke("wholeText", Jsoup.parse((String)h).select("div.commentthread_comment_text").first()), (Object)"\n  Me : Make a 2nd game ?\n Dev : Nah man , too much work.\n Me : So what's it gonna be ?\n Dev : REMASTER !!!!\n ");
        Assert.assertEquals((String)ParseHtmlTests.invoke("parent", Jsoup.parse((String)h).select("p[type*=child]").first()).toString(), (String)"<div>\n <p type=\"child\">childtext</p>\n</div>");
        Assert.assertEquals((Object)ParseHtmlTests.invoke("scriptText", Jsoup.parse((String)h).select("script").first()), (Object)"One Two");
        Assert.assertEquals((Object)ParseHtmlTests.invoke("scriptText", Jsoup.parse((String)h).select("h1").first()), (Object)"");
        Assert.assertTrue((boolean)(ParseHtmlTests.invoke("scriptText", Jsoup.parse((String)h).select("p")) instanceof EvalError));
    }

    static {
        h = "<html>\n<head>\n<script type=\"application/json\">One Two</script></head>\n    <body>\n        <h1>head1</h1>\n        <div class=\"class1\">\n            <p>para1 <strong>strong text</strong></p>\n            <p>para2</p>\n        </div>\n        <div class=\"commentthread_comment_text\" id=\"comment_content_257769\">\n  Me : Make a 2nd game ?\n <br>Dev : Nah man , too much work.\n <br>Me : So what's it gonna be ?\n <br>Dev : REMASTER !!!!\n <br></div><div><p type=\"child\">childtext</p></div>    </body>\n</html>";
    }
}

