/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.util.ParsingUtilities;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ParseUriTest
extends RefineTest {
    private String sampleUri;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.sampleUri = "https://www.openrefine.org:80/documentation#download?format=xml&os=mac";
    }

    @Test
    public void testParseUriValidParams() {
        ObjectNode resNode = (ObjectNode)ParseUriTest.invoke("parseUri", this.sampleUri);
        Assert.assertNotNull((Object)resNode);
        Assert.assertEquals((String)resNode.get("scheme").asText(), (String)"https");
        Assert.assertEquals((String)resNode.get("host").asText(), (String)"www.openrefine.org");
        Assert.assertEquals((int)resNode.get("port").asInt(), (int)80);
        Assert.assertEquals((String)resNode.get("path").asText(), (String)"/documentation");
        Assert.assertEquals((String)resNode.get("fragment").asText(), (String)"download");
        ObjectNode qpExpected = ParsingUtilities.mapper.createObjectNode();
        qpExpected.put("format", "xml");
        qpExpected.put("os", "mac");
        Assert.assertEquals((String)resNode.get("query_params").toString(), (String)qpExpected.toString());
    }

    @Test
    public void testParseUriInvalidParams() {
        Assert.assertTrue((boolean)(ParseUriTest.invoke("parseUri", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(ParseUriTest.invoke("parseUri", "sampleUri") instanceof EvalError));
        Assert.assertTrue((boolean)(ParseUriTest.invoke("parseUri", this.sampleUri, this.sampleUri) instanceof EvalError));
    }
}

