/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.controls.ForEach;
import com.google.refine.util.TestUtils;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForEachTests
extends RefineTest {
    @Test
    public void serializeForEach() {
        String json = "{\"description\":\"Evaluates expression a to an array. Then for each array element, binds its value to variable name v, evaluates expression e, and pushes the result onto the result array.\",\"params\":\"expression a, variable v, expression e\",\"returns\":\"array\"}";
        TestUtils.isSerializedTo(new ForEach(), json);
    }

    private void assertParseError(String expression) throws ParsingException {
        Evaluable eval = MetaParser.parse((String)("grel:" + expression));
        Object result = eval.evaluate(bindings);
        Assert.assertTrue((boolean)(result instanceof EvalError), (String)("Expression didn't return error : " + expression));
    }

    @Test
    public void testInvalidParams() throws ParsingException {
        bindings = new Properties();
        bindings.put("v", "");
        this.assertParseError("forEach('test', v, v)");
        try {
            this.assertParseError("forEach([], 1, 1)");
            Assert.fail((String)"Didn't throw a ParsingException for wrong argument type");
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        try {
            this.assertParseError("forEach([], v)");
            Assert.fail((String)"Didn't throw a ParsingException for 2 arguments");
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        try {
            this.assertParseError("forEach([])");
            Assert.fail((String)"Didn't throw a ParsingException for 1 argument");
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    @Test
    public void testForEachJsonObject() throws ParsingException {
        String json = "{\"2511\": {\"parent_area\": null, \"generation_high\": 40, \"all_names\": {}, \"id\": 2511, \"codes\": {\"ons\": \"00AB\", \"gss\": \"E09000002\", \"local-authority-eng\": \"BDG\", \"local-authority-canonical\": \"BDG\", \"unit_id\": \"10949\"}, \"name\": \"Barking and Dagenham Borough Council\", \"country\": \"E\", \"type_name\": \"London borough\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"LBO\"},\"2247\": {\"parent_area\": null, \"generation_high\": 40, \"all_names\": {}, \"id\": 2247, \"codes\": {\"unit_id\": \"41441\"}, \"name\": \"Greater London Authority\", \"country\": \"E\", \"type_name\": \"Greater London Authority\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"GLA\"},\"8706\": {\"parent_area\": 2511, \"generation_high\": 40, \"all_names\": {}, \"id\": 8706, \"codes\": {\"ons\": \"00ABGH\", \"gss\": \"E05000036\", \"unit_id\": \"10936\"}, \"name\": \"Mayesbrook\", \"country\": \"E\", \"type_name\": \"London borough ward\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"LBW\"}}";
        String[] test = new String[]{"forEach('" + json + "'.parseJson(), v, v.id).sort().join(',')", "2247,2511,8706"};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForEachArray() throws ParsingException {
        String[] test = new String[]{"forEach([5,4,3,2.0], v, v*2).join(',')", "10,8,6,4.0"};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForEachJsonArray() throws ParsingException {
        String[] test = new String[]{"forEach('[3,2,1.0]'.parseJson(), v, v*2).join(',')", "6,4,2.0"};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }
}

