/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.google.refine.RefineTest;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.column.ColumnAdditionOperation;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class HistoryEntryTests
extends RefineTest {
    public static final String fullJson = "{\"id\":1533633623158,\"description\":\"Create new column uri based on column country by filling 269 rows with grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",\"time\":\"2018-08-07T09:06:37Z\",\"operation\":{\"op\":\"core/column-addition\",   \"description\":\"Create column uri at index 2 based on column country using expression grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},   \"newColumnName\":\"uri\",   \"columnInsertIndex\":2,   \"baseColumnName\":\"country\",   \"expression\":\"grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"onError\":\"set-to-blank\"}}";
    public static final String unknownOperationJson = "{\"id\":1533633623158,\"description\":\"some mysterious operation\",\"time\":\"2018-08-07T09:06:37Z\",\"operation\":{\"op\":\"someextension/unknown-operation\",   \"description\":\"some mysterious operation\",   \"some_parameter\":234\n}\n}";
    Project project;

    @BeforeTest
    public void register() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"column-addition", ColumnAdditionOperation.class);
    }

    @BeforeMethod
    public void setUp() {
        this.project = (Project)Mockito.mock(Project.class);
    }

    @Test
    public void serializeHistoryEntry() throws Exception {
        String json = "{\"id\":1533651837506,\"description\":\"Discard recon judgment for single cell on row 76, column organization_name, containing \\\"Catholic University Leuven\\\"\",\"time\":\"2018-08-07T14:18:29Z\"}";
        TestUtils.isSerializedTo(HistoryEntry.load((Project)this.project, (String)json), json);
    }

    @Test
    public void serializeHistoryEntryWithOperation() throws Exception {
        String jsonSimple = "{\"id\":1533633623158,\"description\":\"Create new column uri based on column country by filling 269 rows with grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",\"time\":\"2018-08-07T09:06:37Z\"}";
        HistoryEntry historyEntry = HistoryEntry.load((Project)this.project, (String)fullJson);
        TestUtils.isSerializedTo(historyEntry, jsonSimple, false);
        TestUtils.isSerializedTo(historyEntry, fullJson, true);
    }

    @Test
    public void deserializeUnknownOperation() throws IOException {
        HistoryEntry entry = HistoryEntry.load((Project)this.project, (String)unknownOperationJson);
        TestUtils.isSerializedTo(entry, unknownOperationJson, true);
    }
}

