/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ExcelImporter;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Month;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ExcelImporterTests
extends ImporterTest {
    private static final double EPSILON = 1.0E-7;
    private static final int SHEETS = 3;
    private static final int ROWS = 5;
    private static final int COLUMNS = 6;
    private static final File xlsFile = ExcelImporterTests.createSpreadsheet(false);
    private static final File xlsxFile = ExcelImporterTests.createSpreadsheet(true);
    private static final File xlsFileWithMultiSheets = ExcelImporterTests.createSheetsWithDifferentColumns(false);
    private static final File xlsxFileWithMultiSheets = ExcelImporterTests.createSheetsWithDifferentColumns(true);
    ExcelImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new ExcelImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readXls() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsFile);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)5);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)6);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(2)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readXlsx() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsxFile);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)5);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)6);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(2)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readExcel95() throws FileNotFoundException, IOException {
        InputStream stream = ClassLoader.getSystemResourceAsStream("excel95.xls");
        try {
            Assert.assertEquals((int)this.parseOneFileAndReturnExceptions((ImportingParserBase)this.SUT, stream).size(), (int)1);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void readExcelDates() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        InputStream stream = ClassLoader.getSystemResourceAsStream("dates.xls");
        this.parseOneFile((ImportingParserBase)this.SUT, stream);
        Object cellValue = ((Row)this.project.rows.get(0)).getCellValue(0);
        Assert.assertTrue((boolean)(cellValue instanceof OffsetDateTime));
        OffsetDateTime date = (OffsetDateTime)cellValue;
        Assert.assertEquals((int)date.getYear(), (int)2021);
        Assert.assertEquals((Object)date.getMonth(), (Object)Month.APRIL);
        Assert.assertEquals((int)date.getDayOfMonth(), (int)18);
        Object cellValue2 = ((Row)this.project.rows.get(1)).getCellValue(0);
        Assert.assertTrue((boolean)(cellValue instanceof OffsetDateTime));
        OffsetDateTime date2 = (OffsetDateTime)cellValue2;
        Assert.assertEquals((int)date2.getYear(), (int)2021);
        Assert.assertEquals((Object)date2.getMonth(), (Object)Month.JANUARY);
        Assert.assertEquals((int)date2.getDayOfMonth(), (int)1);
    }

    @Test
    public void readMultiSheetXls() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 1\", fileNameAndSheetIndex: \"file-source#1\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 2\", fileNameAndSheetIndex: \"file-source#2\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsFileWithMultiSheets);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)15);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)6);
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)8);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(5)).getCellValue(0)).doubleValue(), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(5)).getCellValue(6)).doubleValue(), (double)1.0, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(2)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readMultiSheetXlsx() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 1\", fileNameAndSheetIndex: \"file-source#1\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 2\", fileNameAndSheetIndex: \"file-source#2\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsxFileWithMultiSheets);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)15);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)6);
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)8);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(5)).getCellValue(0)).doubleValue(), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(5)).getCellValue(6)).doubleValue(), (double)1.0, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(2)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("storeBlankCellsAsNulls");
    }

    private static File createSpreadsheet(boolean xml) {
        XSSFWorkbook wb = xml ? new XSSFWorkbook() : new HSSFWorkbook();
        CellStyle dateStyle = wb.createCellStyle();
        short dateFormat = wb.createDataFormat().getFormat("yyyy-MM-dd");
        dateStyle.setDataFormat(dateFormat);
        for (int s = 0; s < 3; ++s) {
            Sheet sheet = wb.createSheet("Test Sheet " + s);
            for (int row = 0; row < 5; ++row) {
                ExcelImporterTests.createDataRow(sheet, row, dateStyle, 0);
            }
        }
        File file = null;
        try {
            file = File.createTempFile("openrefine-importer-test", xml ? ".xlsx" : ".xls");
            file.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(file);
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            wb.close();
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private static File createSheetsWithDifferentColumns(boolean xml) {
        XSSFWorkbook wb = xml ? new XSSFWorkbook() : new HSSFWorkbook();
        CellStyle dateStyle = wb.createCellStyle();
        short dateFormat = wb.createDataFormat().getFormat("yyyy-MM-dd");
        dateStyle.setDataFormat(dateFormat);
        for (int s = 0; s < 3; ++s) {
            Sheet sheet = wb.createSheet("Test Sheet " + s);
            for (int row = 0; row < 5; ++row) {
                ExcelImporterTests.createDataRow(sheet, row, dateStyle, s);
            }
        }
        File file = null;
        try {
            file = File.createTempFile("openrefine-importer-test", xml ? ".xlsx" : ".xls");
            file.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(file);
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            wb.close();
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private static void createDataRow(Sheet sheet, int row, CellStyle dateCellStyle, int extra_columns) {
        int col = 0;
        org.apache.poi.ss.usermodel.Row r = sheet.createRow(row);
        Cell c = r.createCell(col++);
        c.setCellValue((double)row * 1.1);
        c = r.createCell(col++);
        c.setCellValue(row % 2 == 0);
        c = r.createCell(col++);
        c.setCellValue(Calendar.getInstance());
        c.setCellStyle(dateCellStyle);
        c = r.createCell(col++);
        c.setCellValue(new Date());
        c.setCellStyle(dateCellStyle);
        c = r.createCell(col++);
        c.setCellValue(" Row " + row + " Col " + col);
        c = r.createCell(col++);
        c.setCellValue("");
        for (int i = 0; i < extra_columns; ++i) {
            c = r.createCell(col++);
            c.setCellValue((double)(i + extra_columns));
        }
    }
}

