/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.refine.RefineTest;
import com.google.refine.importers.ImporterUtilities;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ImporterUtilitiesTests
extends RefineTest {
    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test(enabled=false)
    public void parseCellValueWithText() {
        String END_QUOTES_SHOULD_BE_RETAINED = "\"To be\" is almost always followed by \"or not to be\"";
        String response = (String)((Object)ImporterUtilities.parseCellValue((String)END_QUOTES_SHOULD_BE_RETAINED));
        Assert.assertEquals((String)response, (String)END_QUOTES_SHOULD_BE_RETAINED);
    }

    @Test
    public void getIntegerOption() {
        Properties options = (Properties)Mockito.mock(Properties.class);
        Mockito.when((Object)options.containsKey("testInteger")).thenReturn((Object)true);
        Mockito.when((Object)options.getProperty("testInteger")).thenReturn((Object)"5");
        int response = ImporterUtilities.getIntegerOption((String)"testInteger", (Properties)options, (int)-1);
        Assert.assertEquals((int)5, (int)response);
        ((Properties)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).containsKey("testInteger");
        ((Properties)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).getProperty("testInteger");
    }

    @Test
    public void getIntegerOptionReturnsDefaultOnError() {
        Properties options = (Properties)Mockito.mock(Properties.class);
        Mockito.when((Object)options.containsKey("testInteger")).thenReturn((Object)true);
        Mockito.when((Object)options.getProperty("testInteger")).thenReturn((Object)"notAnInteger");
        int response = ImporterUtilities.getIntegerOption((String)"testInteger", (Properties)options, (int)-1);
        Assert.assertEquals((int)-1, (int)response);
        ((Properties)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).containsKey("testInteger");
        ((Properties)Mockito.verify((Object)options, (VerificationMode)Mockito.times((int)1))).getProperty("testInteger");
    }

    @Test
    public void appendColumnName() {
        ArrayList columnNames = new ArrayList();
        ImporterUtilities.appendColumnName(columnNames, (int)0, (String)"foo");
        ImporterUtilities.appendColumnName(columnNames, (int)1, (String)"bar");
        Assert.assertEquals((int)columnNames.size(), (int)2);
        Assert.assertEquals((String)((String)columnNames.get(0)), (String)"foo");
        Assert.assertEquals((String)((String)columnNames.get(1)), (String)"bar");
    }

    @Test
    public void appendColumnNameFromMultipleRows() {
        ArrayList columnNames = new ArrayList();
        ImporterUtilities.appendColumnName(columnNames, (int)0, (String)"foo");
        ImporterUtilities.appendColumnName(columnNames, (int)0, (String)"bar");
        Assert.assertEquals((int)columnNames.size(), (int)1);
        Assert.assertEquals((String)((String)columnNames.get(0)), (String)"foo bar");
    }

    @Test
    public void ensureColumnsInRowExist() {
        String VALUE_1 = "value1";
        String VALUE_2 = "value2";
        Row row = new Row(2);
        ArrayList<String> columnNames = new ArrayList<String>(2);
        columnNames.add(VALUE_1);
        columnNames.add(VALUE_2);
        ImporterUtilities.ensureColumnsInRowExist(columnNames, (Row)row);
        Assert.assertEquals((int)columnNames.size(), (int)2);
        Assert.assertEquals((String)((String)columnNames.get(0)), (String)VALUE_1);
        Assert.assertEquals((String)((String)columnNames.get(1)), (String)VALUE_2);
    }

    @Test
    public void ensureColumnsInRowExistDoesExpand() {
        Row row = new Row(4);
        for (int i = 1; i < 5; ++i) {
            row.cells.add(new Cell((Serializable)((Object)("value" + i)), null));
        }
        ArrayList columnNames = new ArrayList(2);
        ImporterUtilities.ensureColumnsInRowExist(columnNames, (Row)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertEquals((int)columnNames.size(), (int)4);
    }

    @Test
    public void setupColumns() {
        Project project = new Project();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("col1");
        columnNames.add("col2");
        columnNames.add("");
        ImporterUtilities.setupColumns((Project)project, columnNames);
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(2)).getName(), (String)"Column");
    }

    @Test
    public void testGetOrAllocateColumn() {
        Project project = new Project();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("Column 1");
        columnNames.add("Column 2");
        columnNames.add("Column 3");
        ImporterUtilities.setupColumns((Project)project, columnNames);
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(0)).getName(), (String)"Column 1");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(1)).getName(), (String)"Column 2");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(2)).getName(), (String)"Column 3");
        ArrayList newColumnNames = new ArrayList();
        Column c0 = ImporterUtilities.getOrAllocateColumn((Project)project, newColumnNames, (int)0, (boolean)false);
        Column c1 = ImporterUtilities.getOrAllocateColumn((Project)project, newColumnNames, (int)1, (boolean)false);
        Assert.assertEquals((String)c0.getName(), (String)"Column 1");
        Assert.assertEquals((String)c1.getName(), (String)"Column 2");
        Assert.assertEquals((int)newColumnNames.size(), (int)2);
    }
}

