/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.refine.RefineTest;
import com.google.refine.importers.JsonImporter;
import com.google.refine.importers.JsonImporterTests;
import com.google.refine.importers.XmlImportUtilitiesStub;
import com.google.refine.importers.XmlImporter;
import com.google.refine.importers.XmlImporterTests;
import com.google.refine.importers.tree.ImportColumn;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.ImportParameters;
import com.google.refine.importers.tree.ImportRecord;
import com.google.refine.importers.tree.TreeReader;
import com.google.refine.importers.tree.TreeReaderException;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class XmlImportUtilitiesTests
extends RefineTest {
    Project project;
    TreeReader parser;
    ImportColumnGroup columnGroup;
    ImportRecord record;
    ByteArrayInputStream inputStream;
    XmlImportUtilitiesStub SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new XmlImportUtilitiesStub();
        this.project = new Project();
        this.columnGroup = new ImportColumnGroup();
        this.record = new ImportRecord();
    }

    @Override
    @AfterMethod
    public void TearDown() throws IOException {
        this.SUT = null;
        this.project = null;
        this.parser = null;
        this.columnGroup = null;
        this.record = null;
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = null;
    }

    @Test
    public void detectPathFromTagXmlTest() throws TreeReaderException {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        String tag = "library";
        this.createXmlParser();
        String[] response = XmlImportUtilitiesStub.detectPathFromTag((TreeReader)this.parser, (String)tag);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((int)response.length, (int)1);
        Assert.assertEquals((String)response[0], (String)"library");
    }

    @Test
    public void detectPathFromTagWithNestedElementXml() throws TreeReaderException {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        String tag = "book";
        this.createXmlParser();
        String[] response = XmlImportUtilitiesStub.detectPathFromTag((TreeReader)this.parser, (String)tag);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((int)response.length, (int)2);
        Assert.assertEquals((String)response[0], (String)"library");
        Assert.assertEquals((String)response[1], (String)"book");
    }

    @Test
    public void detectRecordElementXmlTest() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        String tag = "library";
        List<Object> response = new ArrayList();
        try {
            response = this.SUT.detectRecordElementWrapper(this.parser, tag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull(response);
        Assert.assertEquals((int)response.size(), (int)1);
        Assert.assertEquals((String)((String)response.get(0)), (String)"library");
    }

    @Test
    public void detectRecordElementCanHandleWithNestedElementsXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        String tag = "book";
        List<Object> response = new ArrayList();
        try {
            response = this.SUT.detectRecordElementWrapper(this.parser, tag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull(response);
        Assert.assertEquals((int)response.size(), (int)2);
        Assert.assertEquals((String)((String)response.get(0)), (String)"library");
        Assert.assertEquals((String)((String)response.get(1)), (String)"book");
    }

    @Test
    public void detectRecordElementIsNullForUnfoundTagXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        String tag = "";
        List<Object> response = new ArrayList();
        try {
            response = this.SUT.detectRecordElementWrapper(this.parser, tag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNull(response);
    }

    @Test
    public void importTreeDataXmlTest() {
        this.loadSampleXml();
        String[] recordPath = new String[]{"library", "book"};
        try {
            XmlImportUtilitiesStub.importTreeData((TreeReader)this.createXmlParser(), (Project)this.project, (String[])recordPath, (ImportColumnGroup)this.columnGroup, (int)-1, (boolean)false, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((int)this.columnGroup.subgroups.size(), (int)1);
        Assert.assertNotNull(this.columnGroup.subgroups.get("book"));
        Assert.assertEquals((int)((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.size(), (int)3);
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("author"));
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("title"));
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("publish_date"));
    }

    @Test
    public void importTreeDataXmlTestDeprecated() {
        this.loadSampleXml();
        String[] recordPath = new String[]{"library", "book"};
        try {
            XmlImportUtilitiesStub.importTreeData((TreeReader)this.createXmlParser(), (Project)this.project, (String[])recordPath, (ImportColumnGroup)this.columnGroup, (int)-1, (ImportParameters)new ImportParameters(false, true, false));
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((int)this.columnGroup.subgroups.size(), (int)1);
        Assert.assertNotNull(this.columnGroup.subgroups.get("book"));
        Assert.assertEquals((int)((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.size(), (int)3);
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("author"));
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("title"));
        Assert.assertNotNull(((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"book")).subgroups.get("publish_date"));
    }

    @Test
    public void importXmlWithVaryingStructureTest() {
        this.loadData(XmlImporterTests.getSampleWithVaryingStructure());
        String[] recordPath = new String[]{"library", "book"};
        try {
            XmlImportUtilitiesStub.importTreeData((TreeReader)this.createXmlParser(), (Project)this.project, (String[])recordPath, (ImportColumnGroup)this.columnGroup, (int)-1, (boolean)false, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)5)).cells.size(), (int)5);
        Assert.assertEquals((int)this.columnGroup.subgroups.size(), (int)1);
        Assert.assertEquals((String)this.columnGroup.name, (String)"");
        ImportColumnGroup book = (ImportColumnGroup)this.columnGroup.subgroups.get("book");
        Assert.assertNotNull((Object)book);
        Assert.assertEquals((int)book.columns.size(), (int)1);
        Assert.assertEquals((int)book.subgroups.size(), (int)4);
        Assert.assertNotNull(book.subgroups.get("author"));
        Assert.assertEquals((int)((ImportColumnGroup)book.subgroups.get((Object)"author")).columns.size(), (int)1);
        Assert.assertNotNull(book.subgroups.get("title"));
        Assert.assertNotNull(book.subgroups.get("publish_date"));
        Assert.assertNotNull(book.subgroups.get("genre"));
    }

    @Test
    public void importXmlWithVaryingStructureTestDeprecated() {
        this.loadData(XmlImporterTests.getSampleWithVaryingStructure());
        String[] recordPath = new String[]{"library", "book"};
        try {
            XmlImportUtilitiesStub.importTreeData((TreeReader)this.createXmlParser(), (Project)this.project, (String[])recordPath, (ImportColumnGroup)this.columnGroup, (int)-1, (ImportParameters)new ImportParameters(false, true, false));
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)5)).cells.size(), (int)5);
        Assert.assertEquals((int)this.columnGroup.subgroups.size(), (int)1);
        Assert.assertEquals((String)this.columnGroup.name, (String)"");
        ImportColumnGroup book = (ImportColumnGroup)this.columnGroup.subgroups.get("book");
        Assert.assertNotNull((Object)book);
        Assert.assertEquals((int)book.columns.size(), (int)1);
        Assert.assertEquals((int)book.subgroups.size(), (int)4);
        Assert.assertNotNull(book.subgroups.get("author"));
        Assert.assertEquals((int)((ImportColumnGroup)book.subgroups.get((Object)"author")).columns.size(), (int)1);
        Assert.assertNotNull(book.subgroups.get("title"));
        Assert.assertNotNull(book.subgroups.get("publish_date"));
        Assert.assertNotNull(book.subgroups.get("genre"));
    }

    @Test
    public void createColumnsFromImportTest() {
        ImportColumnGroup columnGroup = new ImportColumnGroup();
        ImportColumnGroup subGroup = new ImportColumnGroup();
        columnGroup.columns.put("a", new ImportColumn("hello"));
        columnGroup.columns.put("b", new ImportColumn("world"));
        subGroup.columns.put("c", new ImportColumn("foo"));
        subGroup.columns.put("d", new ImportColumn("bar"));
        columnGroup.subgroups.put("e", subGroup);
        XmlImportUtilitiesStub.createColumnsFromImport((Project)this.project, (ImportColumnGroup)columnGroup);
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 4, 0);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"hello");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"world");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"foo");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(3)).getName(), (String)"bar");
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).keyColumnIndex, (int)2);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).startColumnIndex, (int)2);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).columnSpan, (int)2);
    }

    @Test
    public void findRecordTestXml() {
        this.loadSampleXml();
        this.createXmlParser();
        this.ParserSkip();
        String[] recordPath = new String[]{"library", "book"};
        int pathIndex = 0;
        try {
            this.SUT.findRecordWrapper(this.project, this.parser, recordPath, pathIndex, this.columnGroup, -1, false, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
    }

    @Test
    public void findRecordTestXmlDeprecated() {
        this.loadSampleXml();
        this.createXmlParser();
        this.ParserSkip();
        String[] recordPath = new String[]{"library", "book"};
        int pathIndex = 0;
        try {
            this.SUT.findRecordWrapper(this.project, this.parser, recordPath, pathIndex, this.columnGroup, -1, new ImportParameters(false, false, false));
        }
        catch (Exception e) {
            Assert.fail();
        }
        XmlImportUtilitiesTests.assertProjectCreated(this.project, 0, 6);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
    }

    @Test
    public void processRecordTestXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.project.rows);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1");
    }

    @Test
    public void processRecordTestDuplicateColumnsXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><authors><author>author1</author><author>author2</author></authors><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.project.rows);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)3);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1");
        row = (Row)this.project.rows.get(1);
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author2");
    }

    @Test
    public void processRecordTestNestedElementXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author><author-name>author1</author-name><author-dob>a date</author-dob></author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.project.rows);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1");
        Assert.assertNotNull((Object)row.getCell(2));
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"a date");
    }

    @Test
    public void processSubRecordTestXml() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author>author1</author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processSubRecordWrapper(this.project, this.parser, this.columnGroup, this.record, 0, new ImportParameters(false, false, false));
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((int)this.columnGroup.subgroups.size(), (int)1);
        Assert.assertEquals((String)this.columnGroup.name, (String)"");
        Assert.assertNotNull(this.columnGroup.subgroups.get("library"));
        Assert.assertEquals((int)((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"library")).subgroups.size(), (int)1);
        ImportColumnGroup book = (ImportColumnGroup)((ImportColumnGroup)this.columnGroup.subgroups.get((Object)"library")).subgroups.get("book");
        Assert.assertNotNull((Object)book);
        Assert.assertEquals((int)book.subgroups.size(), (int)2);
        Assert.assertNotNull(book.subgroups.get("author"));
        Assert.assertNotNull(book.subgroups.get("genre"));
    }

    @Test
    public void trimLeadingTrailingWhitespaceOnTrimString() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author><author-name>  author1  </author-name><author-dob>  a date  </author-dob></author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, true, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.project.rows);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1");
        Assert.assertNotNull((Object)row.getCell(2));
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"a date");
    }

    @Test
    public void doesNotTrimLeadingTrailingWhitespaceOnNoTrimString() {
        this.loadData("<?xml version=\"1.0\"?><library><book id=\"1\"><author><author-name>  author1  </author-name><author-dob>  a date  </author-dob></author><genre>genre1</genre></book></library>");
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.project.rows);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"  author1  ");
        Assert.assertNotNull((Object)row.getCell(2));
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"  a date  ");
    }

    @Test
    public void addCellTest() {
        String columnLocalName = "author";
        String text = "Author1, The";
        int commonStartingRowIndex = 0;
        this.SUT.addCellWrapper(this.project, this.columnGroup, this.record, columnLocalName, (Serializable)((Object)text), commonStartingRowIndex);
        Assert.assertNotNull((Object)this.record);
        Assert.assertNotNull((Object)this.record.rows);
        Assert.assertEquals((int)this.record.rows.size(), (int)1);
        Assert.assertNotNull(this.record.rows.get(0));
        Assert.assertEquals((int)((List)this.record.rows.get(0)).size(), (int)1);
        Assert.assertNotNull(((List)this.record.rows.get(0)).get(0));
        Assert.assertEquals((Object)((Cell)((List)this.record.rows.get((int)0)).get((int)0)).value, (Object)"Author1, The");
    }

    @Test
    public void processRecordsFromXmlWithWhiteSpacesBeforeTagsTest() throws IOException {
        this.loadData(this._getXmlDataFromFile("xml-sample-format-1.xml"));
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to parse records from the given XML Data. Reason: " + e.getMessage()), (Throwable)e);
        }
        Assert.assertNotNull((Object)this.project.rows, (String)"Checks the record count of project");
        Assert.assertEquals((int)this.project.rows.size(), (int)3, (String)"Checks the number of records parsed from Xml");
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row, (String)"Checks the row instance with index '0'");
        Assert.assertEquals((int)row.cells.size(), (int)4, (String)"Checks the row cells count");
        Assert.assertNotNull((Object)row.getCell(1), (String)"Checks the cell instance at index '1'");
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1", (String)"Checks the value for 'author-name'");
        Assert.assertNotNull((Object)row.getCell(2), (String)"Checks the cell instance at index '2'");
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"a date", (String)"Checks the value for 'author-dob'");
    }

    @Test
    public void processRecordsFromComplexXmlWithTagsHavingWhitespaces() throws IOException {
        this.loadData(this._getXmlDataFromFile("xml-sample-format-2.xml"));
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to parse records from the given XML Data. Reason: " + e.getMessage()), (Throwable)e);
        }
        Assert.assertNotNull((Object)this.project.rows, (String)"Checks the record count of project");
        Assert.assertEquals((int)this.project.rows.size(), (int)3, (String)"Checks the number of records parsed from Xml");
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row, (String)"Checks the row instance with index '0'");
        Assert.assertEquals((int)row.cells.size(), (int)4, (String)"Checks the row cells count");
        Assert.assertNotNull((Object)row.getCell(1), (String)"Checks the cell instance at index '1'");
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"author1", (String)"Checks the value for first item");
        Assert.assertNotNull((Object)row.getCell(2), (String)"Checks the cell instance at index '2'");
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"a date", (String)"Checks the value for 'author-dob'");
    }

    @Test
    public void processRecordsFromXMLWithDataHavingWhitespaces() throws IOException {
        this.loadData(this._getXmlDataFromFile("xml-sample-format-3.xml"));
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to parse records from the given XML Data. Reason: " + e.getMessage()), (Throwable)e);
        }
        Assert.assertNotNull((Object)this.project.rows, (String)"Checks the record count of project");
        Assert.assertEquals((int)this.project.rows.size(), (int)3, (String)"Checks the number of records parsed from Xml");
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row, (String)"Checks the row instance with index '0'");
        Assert.assertEquals((int)row.cells.size(), (int)4, (String)"Checks the row cells count");
        Assert.assertNotNull((Object)row.getCell(1), (String)"Checks the cell instance at index '1'");
        Assert.assertEquals((String)row.getCell((int)1).value.toString().substring(2, 9), (String)"author1", (String)"Checks the value for first item");
        Assert.assertNotNull((Object)row.getCell(2), (String)"Checks the cell instance at index '2'");
        Assert.assertEquals((String)row.getCell((int)2).value.toString().substring(2, 8), (String)"a date", (String)"Checks the value for 'author-dob'");
    }

    @Test
    public void processRecordsFromComplexXmlStructure() throws IOException {
        this.loadData(this._getXmlDataFromFile("xml-sample-format-4.xml"));
        this.createXmlParser();
        this.ParserSkip();
        try {
            this.SUT.processRecordWrapper(this.project, this.parser, this.columnGroup, false, false, false);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to parse records from the given XML Data. Reason: " + e.getMessage()), (Throwable)e);
        }
        Assert.assertNotNull((Object)this.project.rows, (String)"Checks the record count of project");
        Assert.assertEquals((int)this.project.rows.size(), (int)50, (String)"Checks the number of records parsed from Xml");
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row, (String)"Checks the row instance with index '0'");
        Assert.assertEquals((int)row.cells.size(), (int)14, (String)"Checks the row cells count");
        Assert.assertNotNull((Object)row.getCell(1), (String)"Checks the cell instance at index '1'");
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"11", (String)"Checks the value for 'pages'");
        Assert.assertNotNull((Object)row.getCell(2), (String)"Checks the cell instance at index '2'");
        Assert.assertEquals((Object)row.getCell((int)2).value, (Object)"50", (String)"Checks the value for 'per-page'");
    }

    public void loadSampleXml() {
        this.loadData(XmlImporterTests.getSample());
    }

    public void loadSampleJson() {
        this.loadData(JsonImporterTests.getSample());
    }

    public void loadData(String xml) {
        try {
            this.inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            Assert.fail();
        }
    }

    public void ParserSkip() {
        try {
            if (this.parser.current() == TreeReader.Token.Ignorable) {
                this.parser.next();
            }
        }
        catch (Exception e1) {
            Assert.fail();
        }
    }

    public TreeReader createXmlParser() {
        try {
            this.parser = new XmlImporter.XmlParser((InputStream)this.inputStream);
            return this.parser;
        }
        catch (XMLStreamException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public TreeReader createJsonParser() {
        this.parser = new JsonImporter.JSONTreeReader((InputStream)this.inputStream);
        return this.parser;
    }

    private String _getXmlDataFromFile(String fileName) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
        return content;
    }
}

