/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importing.EncodingGuesser;
import com.google.refine.importing.ImportingJob;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EncodingGuesserTests {
    static String[] ENCODINGS = new String[]{"big5", "euc-jp", "euc-kr", "shift_jis"};

    private static File getTestDir() {
        String dir = ClassLoader.getSystemResource(ENCODINGS[0] + ".html").getPath();
        dir = dir.substring(0, dir.lastIndexOf(47));
        return new File(dir);
    }

    @Test
    public void testEncodingGuesser() throws IOException {
        for (String encoding : ENCODINGS) {
            ImportingJobStub job = new ImportingJobStub();
            ObjectNode config = job.getOrCreateDefaultConfig();
            ObjectNode filesObj = ParsingUtilities.evaluateJsonStringToObjectNode((String)String.format("{ \"files\": [ {\"location\": \"%s.txt\"}]}", encoding));
            JSONUtilities.safePut((ObjectNode)config, (String)"retrievalRecord", (JsonNode)filesObj);
            EncodingGuesser.guess((ImportingJob)job);
            ObjectNode retrievalRecord = job.getRetrievalRecord();
            Assert.assertNotNull((Object)retrievalRecord);
            ArrayNode fileRecords = JSONUtilities.getArray((ObjectNode)retrievalRecord, (String)"files");
            Assert.assertNotNull((Object)fileRecords);
            Assert.assertEquals((int)fileRecords.size(), (int)1);
            ObjectNode record = JSONUtilities.getObjectElement((ArrayNode)fileRecords, (int)0);
            Assert.assertEquals((String)JSONUtilities.getString((JsonNode)record, (String)"encoding", null).toLowerCase(), (String)encoding);
        }
    }

    public class ImportingJobStub
    extends ImportingJob {
        public ImportingJobStub() {
            super(1L, EncodingGuesserTests.getTestDir());
        }

        public File getRawDataDir() {
            return this.dir;
        }
    }
}

