/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.google.refine.ProjectMetadata;
import com.google.refine.io.FileProjectManager;
import com.google.refine.util.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.junit.Assert;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FileProjectManagerTests {
    protected File workspaceDir;
    protected File workspaceFile;

    @BeforeMethod
    public void createDirectory() throws IOException {
        this.workspaceDir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
        this.workspaceFile = File.createTempFile(this.workspaceDir.getPath(), "workspace.json");
    }

    @Test
    public void serializeFileProjectManager() {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        String json = "{\n       \"preferences\" : {\n         \"entries\" : {\n           \"scripting.expressions\" : {\n             \"class\" : \"com.google.refine.preference.TopList\",\n             \"list\" : [ ],\n             \"top\" : 100\n           },\n           \"scripting.starred-expressions\" : {\n             \"class\" : \"com.google.refine.preference.TopList\",\n             \"list\" : [ ],\n             \"top\" : 2147483647\n           }\n         }\n       },\n       \"projectIDs\" : [ 5555 ]\n     }";
        TestUtils.isSerializedTo((Object)manager, json);
    }

    @Test
    public void saveReloadMultinationalCharacter() throws IOException {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        manager.getPreferenceStore().put("testPref", (Object)"Refin\u00e9");
        manager.saveWorkspace();
        manager = new FileProjectManagerStub(this.workspaceDir);
        org.testng.Assert.assertEquals((Object)manager.getPreferenceStore().get("testPref"), (Object)"Refin\u00e9");
    }

    @Test
    public void deleteProjectAndSaveWorkspace() throws IOException {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        manager.saveToFile(this.workspaceFile);
        manager.deleteProject(5555L);
        manager.saveToFile(this.workspaceFile);
        FileInputStream inputStream = new FileInputStream(this.workspaceFile);
        JsonObject json = JSON.parse((InputStream)inputStream);
        Assert.assertTrue((boolean)json.get("projectIDs").getAsArray().isEmpty());
    }

    protected class FileProjectManagerStub
    extends FileProjectManager {
        protected FileProjectManagerStub(File dir) {
            super(dir);
            this._projectsMetadata.put(5555L, (ProjectMetadata)Mockito.mock(ProjectMetadata.class));
        }
    }
}

