/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.expr.functions.FacetCount;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.row.RowRemovalOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CacheTests
extends RefineTest {
    static final String ENGINE_JSON_DUPLICATES = "{\"facets\":[{\"type\":\"list\",\"name\":\"facet A\",\"columnName\":\"Column A\",\"expression\":\"facetCount(value, 'value', 'Column A') > 1\",\"omitBlank\":false,\"omitError\":false,\"selection\":[{\"v\":{\"v\":true,\"l\":\"true\"}}],\"selectBlank\":false,\"selectError\":false,\"invert\":false}],\"mode\":\"row-based\"}}";
    Project project;
    Properties options;
    EngineConfig engine_config;
    Engine engine;
    Properties bindings;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.project = this.createProjectWithColumns("CacheTests", "Column A");
        this.engine = new Engine(this.project);
        this.engine_config = EngineConfig.reconstruct((String)ENGINE_JSON_DUPLICATES);
        this.engine.initializeFromConfig(this.engine_config);
        this.engine.setMode(Engine.Mode.RowBased);
        this.bindings = new Properties();
        this.bindings.put("project", this.project);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.project = null;
        this.engine = null;
        this.bindings = null;
    }

    @Test
    public void testIssue567() throws Exception {
        for (int i = 0; i < 5; ++i) {
            Row row = new Row(5);
            row.setCell(0, new Cell((Serializable)((Object)(i < 4 ? "a" : "b")), null));
            this.project.rows.add(row);
        }
        this.engine.getAllRows().accept(this.project, (RowVisitor)new CountingRowVisitor(5));
        this.engine.getAllFilteredRows().accept(this.project, (RowVisitor)new CountingRowVisitor(4));
        FacetCount fc = new FacetCount();
        Integer count = (Integer)fc.call(this.bindings, new Object[]{"a", "value", "Column A"});
        Assert.assertEquals((int)count, (int)4);
        RowRemovalOperation op = new RowRemovalOperation(this.engine_config);
        op.createProcess(this.project, this.options).performImmediate();
        this.engine.getAllRows().accept(this.project, (RowVisitor)new CountingRowVisitor(1));
        this.engine.getAllFilteredRows().accept(this.project, (RowVisitor)new CountingRowVisitor(0));
        count = (Integer)fc.call(this.bindings, new Object[]{"a", "value", "Column A"});
        Assert.assertEquals((int)count, (int)0);
    }

    class CountingRowVisitor
    implements RowVisitor {
        private int count = 0;
        private int target;

        private CountingRowVisitor(int targetCount) {
            this.target = targetCount;
        }

        public boolean visit(Project project, int rowIndex, Row row) {
            ++this.count;
            return false;
        }

        public void start(Project project) {
            this.count = 0;
        }

        public void end(Project project) {
            Assert.assertEquals((int)this.count, (int)this.target);
        }
    }
}

