/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.RefineTest;
import com.google.refine.history.Change;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.DataExtensionChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DataExtensionChangeTest
extends RefineTest {
    Project project;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.project = this.createCSVProject("reconciled\nsome item");
    }

    @Test
    public void testApplyOldChange() throws Exception {
        Pool pool = new Pool();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("changes/data_extension_2.8.txt");
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(in));
        lineReader.readLine();
        lineReader.readLine();
        Change change = DataExtensionChange.load((LineNumberReader)lineReader, (Pool)pool);
        change.apply(this.project);
        Assert.assertEquals((Object)"Wikimedia content project", (Object)((Row)this.project.rows.get((int)0)).getCell((int)1).value);
    }

    @Test
    public void testApplyNewChange() throws Exception {
        Pool pool = new Pool();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("changes/data_extension_3.0.txt");
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(in));
        lineReader.readLine();
        lineReader.readLine();
        Change change = DataExtensionChange.load((LineNumberReader)lineReader, (Pool)pool);
        change.apply(this.project);
        Assert.assertEquals((Object)"Wikimedia content project", (Object)((Row)this.project.rows.get((int)0)).getCell((int)1).value);
    }
}

