/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.recon;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.ReconCandidate;
import com.google.refine.model.ReconType;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.ReconJob;
import com.google.refine.model.recon.StandardReconConfig;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ReconOperation;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class StandardReconConfigTests
extends RefineTest {
    @BeforeMethod
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"recon", ReconOperation.class);
        ReconConfig.registerReconConfig((ButterflyModule)this.getCoreModule(), (String)"standard-service", StandardReconConfig.class);
    }

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void wordDistance() {
        StandardReconConfigStub t = new StandardReconConfigStub();
        double r = t.wordDistanceTest("Foo", "Foo bar");
        Assert.assertEquals((double)0.5, (double)r);
    }

    @Test
    public void wordDistanceOnlyStopwords() {
        StandardReconConfigStub t = new StandardReconConfigStub();
        double r = t.wordDistanceTest("On and On", "On and On and On");
        Assert.assertTrue((!Double.isInfinite(r) ? 1 : 0) != 0);
        Assert.assertTrue((!Double.isNaN(r) ? 1 : 0) != 0);
    }

    @Test
    public void serializeStandardReconConfig() throws Exception {
        String json = " {\n        \"mode\": \"standard-service\",\n        \"service\": \"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\n        \"identifierSpace\": \"http://www.wikidata.org/entity/\",\n        \"schemaSpace\": \"http://www.wikidata.org/prop/direct/\",\n        \"type\": {\n                \"id\": \"Q13442814\",\n                \"name\": \"scientific article\"\n        },\n        \"autoMatch\": true,\n        \"columnDetails\": [\n           {\n             \"column\": \"organization_country\",\n             \"propertyName\": \"SPARQL: P17/P297\",\n             \"propertyID\": \"P17/P297\"\n           },\n           {\n             \"column\": \"organization_id\",\n             \"propertyName\": \"SPARQL: P3500|P2427\",\n             \"propertyID\": \"P3500|P2427\"\n           }\n        ],\n        \"limit\": 0\n }";
        ReconConfig config = ReconConfig.reconstruct((String)json);
        TestUtils.isSerializedTo(config, json);
        String fullJson = ParsingUtilities.mapper.writeValueAsString((Object)config);
        Assert.assertEquals((int)fullJson.indexOf("\"mode\"", fullJson.indexOf("\"mode\"") + 1), (int)-1);
    }

    @Test
    public void testReconstructNoType() throws IOException {
        String json = "{\"mode\":\"standard-service\",\"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\"identifierSpace\":\"http://www.wikidata.org/entity/\",\"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",\"type\":null,\"autoMatch\":true,\"columnDetails\":[    {\"column\":\"_ - id\",     \"property\":{\"id\":\"P3153\",\"name\":\"Crossref funder ID\"}}],\"limit\":0}";
        StandardReconConfig config = StandardReconConfig.reconstruct((String)json);
        Assert.assertNull((Object)config.typeID);
        Assert.assertNull((Object)config.typeName);
    }

    @Test
    public void testReconstructNoIdentifierSchemaSpaces() throws IOException {
        String json = "{\"mode\":\"standard-service\",\"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\"type\":null,\"autoMatch\":true,\"columnDetails\":[],\"limit\":0}";
        StandardReconConfig config = StandardReconConfig.reconstruct((String)json);
        Assert.assertEquals((String)config.identifierSpace, (String)"http://localhost/identifier");
        Assert.assertEquals((String)config.schemaSpace, (String)"http://localhost/schema");
    }

    @Test
    public void formulateQueryTest() throws IOException {
        Project project = this.createCSVProject("title,director\nmulholland drive,david lynch");
        String config = " {\n        \"mode\": \"standard-service\",\n        \"service\": \"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\n        \"identifierSpace\": \"http://www.wikidata.org/entity/\",\n        \"schemaSpace\": \"http://www.wikidata.org/prop/direct/\",\n        \"type\": {\n                \"id\": \"Q1234\",\n                \"name\": \"movie\"\n        },\n        \"autoMatch\": true,\n        \"columnDetails\": [\n           {\n             \"column\": \"director\",\n             \"propertyName\": \"Director\",\n             \"propertyID\": \"P123\"\n           }\n        ]}";
        StandardReconConfig r = StandardReconConfig.reconstruct((String)config);
        Row row = (Row)project.rows.get(0);
        ReconJob job = r.createJob(project, 0, row, "title", row.getCell(0));
        TestUtils.assertEqualsAsJson(job.toString(), "{\"query\":\"mulholland drive\",\"type\":\"Q1234\",\"properties\":[     {\"pid\":\"P123\",\"v\":\"david lynch\"}],\"type_strict\":\"should\"}");
    }

    @Test
    public void reconNonJsonTest() throws Exception {
        Project project = this.createCSVProject("title,director\nmulholland drive,david lynch");
        String nonJsonResponse = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Error</title>\n  </head>\n  <body>\n    You have reached an error page.\n  </body>\n</html>";
        try (MockWebServer server = new MockWebServer();){
            server.start();
            HttpUrl url = server.url("/openrefine-wikidata/en/api");
            server.enqueue(new MockResponse().setBody(nonJsonResponse));
            server.enqueue(new MockResponse());
            String configJson = " {\n        \"mode\": \"standard-service\",\n        \"service\": \"" + url + "\",\n        \"identifierSpace\": \"http://www.wikidata.org/entity/\",\n        \"schemaSpace\": \"http://www.wikidata.org/prop/direct/\",\n        \"type\": {\n                \"id\": \"Q11424\",\n                \"name\": \"film\"\n        },\n        \"autoMatch\": true,\n        \"columnDetails\": [\n           {\n             \"column\": \"director\",\n             \"propertyName\": \"Director\",\n             \"propertyID\": \"P57\"\n           }\n        ]}";
            StandardReconConfig config = StandardReconConfig.reconstruct((String)configJson);
            ReconOperation op = new ReconOperation(EngineConfig.reconstruct(null), "director", (ReconConfig)config);
            Process process = op.createProcess(project, new Properties());
            ProcessManager pm = project.getProcessManager();
            process.startPerforming(pm);
            Assert.assertTrue((boolean)process.isRunning());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Test interrupted");
            }
            Assert.assertFalse((boolean)process.isRunning());
            RecordedRequest request1 = server.takeRequest();
            Assert.assertNotNull((Object)request1);
            Row row = (Row)project.rows.get(0);
            Cell cell = (Cell)row.cells.get(1);
            Assert.assertNotNull((Object)cell.value);
            Assert.assertNull((Object)cell.recon);
        }
    }

    @Test
    public void reconTest() throws Exception {
        Project project = this.createCSVProject("title,director\nmulholland drive,david lynch");
        String reconResponse = "{\nq0: {\n  result: [\n    {\n    P57: {\nscore: 100,\nweighted: 40\n},\nall_labels: {\nscore: 59,\nweighted: 59\n},\nscore: 70.71428571428572,\nid: \"Q3989262\",\nname: \"The Short Films of David Lynch\",\ntype: [\n{\nid: \"Q24862\",\nname: \"short film\"\n},\n{\nid: \"Q202866\",\nname: \"animated film\"\n}\n],\nmatch: false\n},\n{\nP57: {\nscore: 100,\nweighted: 40\n},\nall_labels: {\nscore: 44,\nweighted: 44\n},\nscore: 60.00000000000001,\nid: \"Q83365219\",\nname: \"What Did Jack Do?\",\ntype: [\n{\nid: \"Q24862\",\nname: \"short film\"\n}\n],\nmatch: false\n    }\n    ]\n  }\n}\n";
        try (MockWebServer server = new MockWebServer();){
            server.start();
            HttpUrl url = server.url("/openrefine-wikidata/en/api");
            server.enqueue(new MockResponse().setResponseCode(503));
            server.enqueue(new MockResponse().setBody(reconResponse));
            server.enqueue(new MockResponse());
            String configJson = " {\n        \"mode\": \"standard-service\",\n        \"service\": \"" + url + "\",\n        \"identifierSpace\": \"http://www.wikidata.org/entity/\",\n        \"schemaSpace\": \"http://www.wikidata.org/prop/direct/\",\n        \"type\": {\n                \"id\": \"Q11424\",\n                \"name\": \"film\"\n        },\n        \"autoMatch\": true,\n        \"columnDetails\": [\n           {\n             \"column\": \"director\",\n             \"propertyName\": \"Director\",\n             \"propertyID\": \"P57\"\n           }\n        ]}";
            StandardReconConfig config = StandardReconConfig.reconstruct((String)configJson);
            ReconOperation op = new ReconOperation(EngineConfig.reconstruct(null), "director", (ReconConfig)config);
            Process process = op.createProcess(project, new Properties());
            ProcessManager pm = project.getProcessManager();
            process.startPerforming(pm);
            Assert.assertTrue((boolean)process.isRunning());
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Test interrupted");
            }
            Assert.assertFalse((boolean)process.isRunning());
            server.takeRequest();
            RecordedRequest request1 = server.takeRequest();
            Assert.assertNotNull((Object)request1);
            String query = request1.getBody().readUtf8Line();
            Assert.assertNotNull((Object)query);
            String expected = "queries=" + URLEncoder.encode("{\"q0\":{\"query\":\"david lynch\",\"type\":\"Q11424\",\"properties\":[{\"pid\":\"P57\",\"v\":\"david lynch\"}],\"type_strict\":\"should\"}}", "UTF-8");
            Assert.assertEquals((String)query, (String)expected);
            Row row = (Row)project.rows.get(0);
            Cell cell = (Cell)row.cells.get(1);
            Assert.assertNotNull((Object)cell.recon);
            Assert.assertEquals((String)cell.recon.service, (String)url.toString());
            Assert.assertEquals((String)cell.recon.getBestCandidate().types[0], (String)"Q24862");
        }
    }

    @Test
    public void deserializeColumnDetail() throws JsonParseException, JsonMappingException, IOException {
        String uiJson = "{\"column\":\"director\",\"property\":{   \"id\":\"P123\",   \"name\":\"Director\"}}";
        String backendJson = "{\"column\":\"director\",\"propertyID\":\"P123\",\"propertyName\":\"Director\"}";
        StandardReconConfig.ColumnDetail cd = (StandardReconConfig.ColumnDetail)ParsingUtilities.mapper.readValue(uiJson, StandardReconConfig.ColumnDetail.class);
        TestUtils.isSerializedTo(cd, backendJson);
    }

    @Test
    public void deserializeReconResult() throws JsonParseException, JsonMappingException, IOException {
        String json = "{\"score\":100.0,\"match\":false,\"type\":[   {\"id\":\"Q17366755\",    \"name\":\"hamlet in Alberta\"}],\"id\":\"Q5136635\",\"name\":\"Cluny\"}";
        StandardReconConfig.ReconResult rr = (StandardReconConfig.ReconResult)ParsingUtilities.mapper.readValue(json, StandardReconConfig.ReconResult.class);
        Assert.assertEquals((String)((ReconType)rr.types.get((int)0)).name, (String)"hamlet in Alberta");
    }

    @Test
    public void reorderReconciliationResults() throws JsonParseException, JsonMappingException, IOException {
        String viafJson = " [\n\n    {\n        \"id\": \"18951129\",\n        \"name\": \"Varano, Camilla Battista da 1458-1524\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.1282051282051282,\n        \"match\": false\n    },\n    {\n        \"id\": \"102271932\",\n        \"name\": \"Shamsie, Kamila, 1973-....\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.23076923076923078,\n        \"match\": false\n    },\n    {\n        \"id\": \"63233597\",\n        \"name\": \"Camilla, Duchess of Cornwall, 1947-\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.14285714285714285,\n        \"match\": false\n    }\n\n]";
        StandardReconConfigStub stub = new StandardReconConfigStub();
        ArrayNode node = (ArrayNode)ParsingUtilities.mapper.readValue(viafJson, ArrayNode.class);
        Recon recon = stub.createReconServiceResults("Kamila", node, 1234L);
        Assert.assertTrue((((ReconCandidate)recon.candidates.get((int)0)).score > 0.2 ? 1 : 0) != 0);
        Assert.assertEquals((String)((ReconCandidate)recon.candidates.get((int)0)).id, (String)"102271932");
    }

    @Test
    public void reorderReconciliationResultsStableSort() throws JsonParseException, JsonMappingException, IOException {
        String viafJson = " [\n\n    {\n        \"id\": \"18951129\",\n        \"name\": \"Varano, Camilla Battista da 1458-1524\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.3,\n        \"match\": false\n    },\n    {\n        \"id\": \"102271932\",\n        \"name\": \"Shamsie, Kamila, 1973-....\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.23076923076923078,\n        \"match\": false\n    },\n    {\n        \"id\": \"63233597\",\n        \"name\": \"Camilla, Duchess of Cornwall, 1947-\",\n        \"type\": [\n            {\n                \"id\": \"/people/person\",\n                \"name\": \"Person\"\n            }\n        ],\n        \"score\": 0.3,\n        \"match\": false\n    }\n\n]";
        StandardReconConfigStub stub = new StandardReconConfigStub();
        ArrayNode node = (ArrayNode)ParsingUtilities.mapper.readValue(viafJson, ArrayNode.class);
        Recon recon = stub.createReconServiceResults("Kamila", node, 1234L);
        Assert.assertEquals((double)((ReconCandidate)recon.candidates.get((int)0)).score, (double)0.3);
        Assert.assertEquals((String)((ReconCandidate)recon.candidates.get((int)0)).id, (String)"18951129");
    }

    @Test
    public void testComputeFeatures() {
        StandardReconConfigStub stub = new StandardReconConfigStub();
        Recon recon = stub.createNewRecon(2384738L);
        stub.computeFeatures(recon, "my string");
        Assert.assertNotNull((Object)recon.features);
    }

    @Test
    public void testComputeFeaturesNullText() {
        StandardReconConfigStub stub = new StandardReconConfigStub();
        Recon recon = stub.createNewRecon(2384738L);
        stub.computeFeatures(recon, null);
        Assert.assertNotNull((Object)recon.features);
    }

    private class StandardReconConfigStub
    extends StandardReconConfig {
        public StandardReconConfigStub() {
            super("", "", "", "", "", false, new ArrayList());
        }

        public double wordDistanceTest(String s1, String s2) {
            return StandardReconConfigStub.wordDistance((String)s1, (String)s2);
        }

        protected Recon createReconServiceResults(String text, ArrayNode resultsList, long historyEntryID) {
            return super.createReconServiceResults(text, resultsList, historyEntryID);
        }
    }
}

