/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.FillDownOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.ArrayList;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class FillDownTests
extends RefineTest {
    Project project = null;

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"fill-down", FillDownOperation.class);
    }

    @BeforeMethod
    public void setUp() {
        this.project = this.createCSVProject("key,first,second\na,b,c\n,d,\ne,f,\n,,h\n");
    }

    @AfterMethod
    public void tearDown() {
        ProjectManager.singleton.deleteProject(this.project.id);
    }

    @Test
    public void serializeFillDownOperation() throws Exception {
        String json = "{\"op\":\"core/fill-down\",\"description\":\"Fill down cells in column my key\",\"engineConfig\":{\"mode\":\"record-based\",\"facets\":[]},\"columnName\":\"my key\"}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, FillDownOperation.class), json);
    }

    @Test
    public void testFillDownRecordKey() throws Exception {
        FillDownOperation op = new FillDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"record-based\",\"facets\":[]}"), "key");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"a", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"a", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"e", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"e", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)0)).value);
    }

    @Test
    public void testFillDownRecords() throws Exception {
        FillDownOperation op = new FillDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"record-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value);
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)2)).cells.get(2));
        Assert.assertEquals((Object)"h", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)2)).value);
    }

    @Test
    public void testFillDownRows() throws Exception {
        FillDownOperation op = new FillDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"row-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value);
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value);
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)2)).value);
        Assert.assertEquals((Object)"h", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)2)).value);
    }

    @Test
    public void testKeyColumnIndex() throws Exception {
        for (Object r : this.project.rows) {
            ((Row)r).cells.add(0, null);
        }
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (Column c : this.project.columnModel.columns) {
            newColumns.add(new Column(c.getCellIndex() + 1, c.getName()));
        }
        this.project.columnModel.columns.clear();
        this.project.columnModel.columns.addAll(newColumns);
        this.project.columnModel.update();
        FillDownOperation op = new FillDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"record-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value);
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)3)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)2)).cells.get(3));
        Assert.assertEquals((Object)"h", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)3)).value);
    }
}

