/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.google.refine.RefineTest;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.MultiValuedCellJoinOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class JoinMultiValuedCellsTests
extends RefineTest {
    Project project;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"multivalued-cell-join", MultiValuedCellJoinOperation.class);
    }

    @BeforeMethod
    public void createProject() {
        this.project = this.createCSVProject("Key,Value\nRecord_1,one\n,two\n,three\n,four\n");
    }

    @Test
    public void serializeMultiValuedCellJoinOperation() throws Exception {
        String json = "{\"op\":\"core/multivalued-cell-join\",\"description\":\"Join multi-valued cells in column value column\",\"columnName\":\"value column\",\"keyColumnName\":\"key column\",\"separator\":\",\"}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, MultiValuedCellJoinOperation.class), json);
    }

    @Test
    public void testJoinMultiValuedCells() throws Exception {
        MultiValuedCellJoinOperation op = new MultiValuedCellJoinOperation("Value", "Key", ",");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one,two,three,four");
    }

    @Test
    public void testJoinMultiValuedCellsMultipleSpaces() throws Exception {
        MultiValuedCellJoinOperation op = new MultiValuedCellJoinOperation("Value", "Key", ",     ,");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one,     ,two,     ,three,     ,four");
    }
}

