/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.RefineServletStub;
import com.google.refine.RefineTest;
import com.google.refine.importers.SeparatorBasedImporter;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.io.FileProjectManager;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.KeyValueColumnizeOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class KeyValueColumnizeTests
extends RefineTest {
    private RefineServlet servlet;
    private Project project;
    private ProjectMetadata pm;
    private ObjectNode options;
    private ImportingJob job;
    private SeparatorBasedImporter importer;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.servlet = new RefineServletStub();
        File dir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
        FileProjectManager.initialize((File)dir);
        this.project = new Project();
        this.pm = new ProjectMetadata();
        this.pm.setName("KeyValueColumnize test");
        ProjectManager.singleton.registerProject(this.project, this.pm);
        this.options = (ObjectNode)Mockito.mock(ObjectNode.class);
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"key-value-columnize", KeyValueColumnizeOperation.class);
        ImportingManager.initialize((RefineServlet)this.servlet);
        this.job = ImportingManager.createJob();
        this.importer = new SeparatorBasedImporter();
    }

    @Override
    @AfterMethod
    public void TearDown() {
        ImportingManager.disposeJob((long)this.job.id);
        ProjectManager.singleton.deleteProject(this.project.id);
        this.job = null;
        this.project = null;
        this.pm = null;
        this.options = null;
    }

    @Test
    public void serializeKeyValueColumnizeOperation() throws Exception {
        String json = "{\"op\":\"core/key-value-columnize\",\"description\":\"Columnize by key column key column and value column value column\",\"keyColumnName\":\"key column\",\"valueColumnName\":\"value column\",\"noteColumnName\":null}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, KeyValueColumnizeOperation.class), json);
        String jsonFull = "{\"op\":\"core/key-value-columnize\",\"description\":\"Columnize by key column key column and value column value column with note column note column\",\"keyColumnName\":\"key column\",\"valueColumnName\":\"value column\",\"noteColumnName\":\"note column\"}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(jsonFull, KeyValueColumnizeOperation.class), jsonFull);
    }

    @Test
    public void testKeyValueColumnizeWithID() throws Exception {
        Project project = this.createCSVProject("ID,Cat,Val\n1,a,1\n1,b,3\n2,b,4\n2,c,5\n3,a,2\n3,b,5\n3,d,3\n");
        KeyValueColumnizeOperation op = new KeyValueColumnizeOperation("Cat", "Val", null);
        Process process = op.createProcess(project, new Properties());
        process.performImmediate();
        Assert.assertEquals((int)project.columnModel.columns.size(), (int)5);
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(0)).getName(), (String)"ID");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(1)).getName(), (String)"a");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(2)).getName(), (String)"b");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(3)).getName(), (String)"c");
        Assert.assertEquals((String)((Column)project.columnModel.columns.get(4)).getName(), (String)"d");
        Assert.assertEquals((int)project.rows.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).value, (Object)"1");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)0)).cells.get((int)3)).value, (Object)"1");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)0)).cells.get((int)4)).value, (Object)"3");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).value, (Object)"2");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)4)).value, (Object)"4");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)5)).value, (Object)"5");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)2)).cells.get((int)0)).value, (Object)"3");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)2)).cells.get((int)3)).value, (Object)"2");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)2)).cells.get((int)4)).value, (Object)"5");
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)2)).cells.get((int)6)).value, (Object)"3");
    }

    @Test
    public void testKeyValueColumnize() throws Exception {
        String csv = "Key,Value\nmerchant,Katie\nfruit,apple\nprice,1.2\nfruit,pear\nprice,1.5\nmerchant,John\nfruit,banana\nprice,3.1\n";
        this.prepareOptions(",", 20, 0, 0, 1, false, false);
        ArrayList exceptions = new ArrayList();
        this.importer.parseOneFile(this.project, this.pm, this.job, "filesource", (Reader)new StringReader(csv), -1, this.options, exceptions);
        this.project.update();
        ProjectManager.singleton.registerProject(this.project, this.pm);
        KeyValueColumnizeOperation op = new KeyValueColumnizeOperation("Key", "Value", null);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int merchantCol = this.project.columnModel.getColumnByName("merchant").getCellIndex();
        int fruitCol = this.project.columnModel.getColumnByName("fruit").getCellIndex();
        int priceCol = this.project.columnModel.getColumnByName("price").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(merchantCol), (Object)"Katie");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(merchantCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(merchantCol), (Object)"John");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(fruitCol), (Object)"apple");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(fruitCol), (Object)"pear");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(fruitCol), (Object)"banana");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(priceCol), (Object)"1.2");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(priceCol), (Object)"1.5");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(priceCol), (Object)"3.1");
    }

    private void prepareOptions(String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes) {
        KeyValueColumnizeTests.whenGetStringOption("separator", this.options, sep);
        KeyValueColumnizeTests.whenGetIntegerOption("limit", this.options, limit);
        KeyValueColumnizeTests.whenGetIntegerOption("skipDataLines", this.options, skip);
        KeyValueColumnizeTests.whenGetIntegerOption("ignoreLines", this.options, ignoreLines);
        KeyValueColumnizeTests.whenGetIntegerOption("headerLines", this.options, headerLines);
        KeyValueColumnizeTests.whenGetBooleanOption("guessCellValueTypes", this.options, guessValueType);
        KeyValueColumnizeTests.whenGetBooleanOption("processQuotes", this.options, !ignoreQuotes);
        KeyValueColumnizeTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
    }
}

