/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.refine.RefineTest;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.MassEditOperation;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class MassOperationTests
extends RefineTest {
    private List<MassEditOperation.Edit> editList;
    private String editsString;

    @BeforeSuite
    public void setUp() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"mass-edit", MassEditOperation.class);
    }

    @Test
    public void serializeMassEditOperation() throws Exception {
        String json = "{\"op\":\"core/mass-edit\",\"description\":\"Mass edit cells in column my column\",\"engineConfig\":{\"mode\":\"record-based\",\"facets\":[]},\"columnName\":\"my column\",\"expression\":\"value\",\"edits\":[{\"fromBlank\":false,\"fromError\":false,\"from\":[\"String\"],\"to\":\"newString\"}]}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, MassEditOperation.class), json);
    }

    @Test
    public void testReconstructEditString() throws Exception {
        this.editsString = "[{\"from\":[\"String\"],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((int)this.editList.get((int)0).from.size(), (int)1);
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"String");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertFalse((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }

    @Test
    public void testReconstructEditMultiString() throws Exception {
        this.editsString = "[{\"from\":[\"String1\",\"String2\"],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((int)this.editList.get((int)0).from.size(), (int)2);
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"String1");
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(1)), (String)"String2");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertFalse((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }

    @Test
    public void testReconstructEditBoolean() throws Exception {
        this.editsString = "[{\"from\":[true],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((int)this.editList.get((int)0).from.size(), (int)1);
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"true");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertFalse((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }

    @Test
    public void testReconstructEditNumber() throws Exception {
        this.editsString = "[{\"from\":[1],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((int)this.editList.get((int)0).from.size(), (int)1);
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"1");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertFalse((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }

    @Test
    public void testReconstructEditDate() throws Exception {
        this.editsString = "[{\"from\":[\"2018-10-04T00:00:00Z\"],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"2018-10-04T00:00:00Z");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertFalse((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }

    @Test
    public void testReconstructEditEmpty() throws Exception {
        this.editsString = "[{\"from\":[\"\"],\"to\":\"newString\",\"type\":\"text\"}]";
        this.editList = (List)ParsingUtilities.mapper.readValue(this.editsString, (TypeReference)new TypeReference<List<MassEditOperation.Edit>>(){});
        Assert.assertEquals((int)this.editList.get((int)0).from.size(), (int)1);
        Assert.assertEquals((String)((String)this.editList.get((int)0).from.get(0)), (String)"");
        Assert.assertEquals((Object)this.editList.get((int)0).to, (Object)"newString");
        Assert.assertTrue((boolean)this.editList.get((int)0).fromBlank);
        Assert.assertFalse((boolean)this.editList.get((int)0).fromError);
    }
}

