/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.google.refine.RefineTest;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.MultiValuedCellSplitOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SplitMultiValuedCellsTests
extends RefineTest {
    Project project;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"multivalued-cell-split", MultiValuedCellSplitOperation.class);
    }

    @BeforeMethod
    public void createProject() {
        this.project = this.createCSVProject("Key,Value\nRecord_1,one:two;three four;fiveSix Sev\u00e8\u00cbight;nin\u00e991011twelve thirteen 14\u00c0ifteen\n");
    }

    @Test
    public void serializeMultiValuedCellSplitOperationWithSeparator() throws Exception {
        String json = "{\"op\":\"core/multivalued-cell-split\",\"description\":\"Split multi-valued cells in column Value\",\"columnName\":\"Value\",\"keyColumnName\":\"Key\",\"mode\":\"separator\",\"separator\":\":\",\"regex\":false}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, MultiValuedCellSplitOperation.class), json);
    }

    @Test
    public void serializeMultiValuedCellSplitOperationWithLengths() throws Exception {
        String json = "{\"op\":\"core/multivalued-cell-split\",\"description\":\"Split multi-valued cells in column Value\",\"columnName\":\"Value\",\"keyColumnName\":\"Key\",\"mode\":\"lengths\",\"fieldLengths\":[1,1]}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, MultiValuedCellSplitOperation.class), json);
    }

    @Test
    public void testSplitMultiValuedCellsTextSeparator() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", ":", false);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"two;three four;fiveSix Sev\u00e8\u00cbight;nin\u00e991011twelve thirteen 14\u00c0ifteen");
    }

    @Test
    public void testSplitMultiValuedCellsRegExSeparator() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", "\\W", true);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"two");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"three");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(valueCol), (Object)"four");
    }

    @Test
    public void testSplitMultiValuedCellsLengths() throws Exception {
        int[] lengths = new int[]{4, 4, 6, 4};
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", lengths);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one:");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"two;");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"three ");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(valueCol), (Object)"four");
    }

    @Test
    public void testSplitMultiValuedCellsTextCase() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", "(?<=\\p{Lower}|[\\p{Lower}][\\s])(?=\\p{Upper})", true);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one:two;three four;five");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"Six ");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"Sev\u00e8");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(valueCol), (Object)"\u00cbight;nin\u00e991011twelve thirteen 14\u00c0ifteen");
    }

    @Test
    public void testSplitMultiValuedCellsTextCaseReverse() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", "(?<=\\p{Upper}|[\\p{Upper}][\\s])(?=\\p{Lower})", true);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one:two;three four;fiveS");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"ix S");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"ev\u00e8\u00cb");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(valueCol), (Object)"ight;nin\u00e991011twelve thirteen 14\u00c0");
        Assert.assertEquals((Object)((Row)this.project.rows.get(4)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(4)).getCellValue(valueCol), (Object)"ifteen");
    }

    @Test
    public void testSplitMultiValuedCellsTextNumber() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", "(?<=\\p{Digit}|[\\p{Digit}][\\s])(?=\\p{L})", true);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one:two;three four;fiveSix Sev\u00e8\u00cbight;nin\u00e991011");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"twelve thirteen 14");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"\u00c0ifteen");
    }

    @Test
    public void testSplitMultiValuedCellsTextNumberReverse() throws Exception {
        MultiValuedCellSplitOperation op = new MultiValuedCellSplitOperation("Value", "Key", "(?<=\\p{L}|[\\p{L}][\\s])(?=\\p{Digit})", true);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        int keyCol = this.project.columnModel.getColumnByName("Key").getCellIndex();
        int valueCol = this.project.columnModel.getColumnByName("Value").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(keyCol), (Object)"Record_1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(valueCol), (Object)"one:two;three four;fiveSix Sev\u00e8\u00cbight;nin\u00e9");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(valueCol), (Object)"91011twelve thirteen ");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(keyCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(valueCol), (Object)"14\u00c0ifteen");
    }
}

