/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.column;

import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.EngineDependentOperation;
import com.google.refine.operations.OnError;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.column.ColumnAdditionByFetchingURLsOperation;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ColumnAdditionByFetchingURLsOperationTests
extends RefineTest {
    static final String ENGINE_JSON_URLS = "{\"mode\":\"row-based\"}";
    private String json = "{\"op\":\"core/column-addition-by-fetching-urls\",\"description\":\"Create column employments at index 2 by fetching URLs based on column orcid using expression grel:\\\"https://pub.orcid.org/\\\"+value+\\\"/employments\\\"\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"newColumnName\":\"employments\",\"columnInsertIndex\":2,\"baseColumnName\":\"orcid\",\"urlExpression\":\"grel:\\\"https://pub.orcid.org/\\\"+value+\\\"/employments\\\"\",\"onError\":\"set-to-blank\",\"delay\":500,\"cacheResponses\":true,\"httpHeadersJson\":[    {\"name\":\"authorization\",\"value\":\"\"},    {\"name\":\"user-agent\",\"value\":\"OpenRefine 3.0 rc.1 [TRUNK]\"},    {\"name\":\"accept\",\"value\":\"application/json\"}]}";
    private String processJson = "{\n    \"description\" : \"Create column employments at index 2 by fetching URLs based on column orcid using expression grel:\\\"https://pub.orcid.org/\\\"+value+\\\"/employments\\\"\",\n    \"id\" : %d,\n    \"immediate\" : false,\n    \"progress\" : 0,\n    \"status\" : \"pending\"\n }";
    private Project project;
    private Properties options;
    private EngineConfig engine_config = EngineConfig.reconstruct((String)"{\"mode\":\"row-based\"}");

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"column-addition-by-fetching-urls", ColumnAdditionByFetchingURLsOperation.class);
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.project = this.createProjectWithColumns("UrlFetchingTests", "fruits");
    }

    private void runAndWait(EngineDependentOperation op, int timeout) throws Exception {
        ProcessManager pm = this.project.getProcessManager();
        Process process = op.createProcess(this.project, this.options);
        this.runAndWait(pm, process, timeout);
    }

    @Test
    public void serializeColumnAdditionByFetchingURLsOperation() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.json, ColumnAdditionByFetchingURLsOperation.class), this.json);
    }

    @Test
    public void serializeUrlFetchingProcess() throws Exception {
        AbstractOperation op = (AbstractOperation)ParsingUtilities.mapper.readValue(this.json, ColumnAdditionByFetchingURLsOperation.class);
        Process process = op.createProcess(this.project, new Properties());
        TestUtils.isSerializedTo(process, String.format(this.processJson, process.hashCode()));
    }

    @Test
    public void testUrlCaching() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            server.start();
            HttpUrl url = server.url("/random");
            Random rand = new Random();
            for (int i = 0; i < 100; ++i) {
                Row row = new Row(2);
                row.setCell(0, new Cell((Serializable)((Object)(i < 5 ? "apple" : "orange")), null));
                this.project.rows.add(row);
                server.enqueue(new MockResponse().setBody(Integer.toString(rand.nextInt(100))));
            }
            ColumnAdditionByFetchingURLsOperation op = new ColumnAdditionByFetchingURLsOperation(this.engine_config, "fruits", "\"" + url + "?city=\"+value", OnError.StoreError, "rand", 1, 500, true, null);
            this.runAndWait((EngineDependentOperation)op, 1500);
            String ref_val = ((Row)this.project.rows.get(0)).getCellValue(1).toString();
            Assert.assertFalse((boolean)ref_val.equals("apple"));
            for (int i = 1; i < 4; ++i) {
                Assert.assertEquals((String)((Row)this.project.rows.get(i)).getCellValue(1).toString(), (String)ref_val);
            }
            server.shutdown();
        }
    }

    @Test
    public void testInvalidUrl() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            server.start();
            HttpUrl url = server.url("/random");
            server.enqueue(new MockResponse());
            Row row0 = new Row(2);
            row0.setCell(0, new Cell((Serializable)((Object)"auinrestrsc"), null));
            this.project.rows.add(row0);
            Row row1 = new Row(2);
            row1.setCell(0, new Cell((Serializable)((Object)url.toString()), null));
            this.project.rows.add(row1);
            Row row2 = new Row(2);
            row2.setCell(0, new Cell((Serializable)((Object)"http://domain.invalid/random"), null));
            this.project.rows.add(row2);
            ColumnAdditionByFetchingURLsOperation op = new ColumnAdditionByFetchingURLsOperation(this.engine_config, "fruits", "value", OnError.StoreError, "junk", 1, 50, true, null);
            this.runAndWait((EngineDependentOperation)op, 3000);
            int newCol = this.project.columnModel.getColumnByName("junk").getCellIndex();
            Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(newCol), null);
            Assert.assertTrue((((Row)this.project.rows.get(1)).getCellValue(newCol) != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ExpressionUtils.isError((Object)((Row)this.project.rows.get(2)).getCellValue(newCol)));
        }
    }

    @Test
    public void testHttpHeaders() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            server.start();
            HttpUrl url = server.url("/checkheader");
            Row row0 = new Row(2);
            row0.setCell(0, new Cell((Serializable)((Object)url.toString()), null));
            this.project.rows.add(row0);
            String userAgentValue = "OpenRefine";
            String authorizationValue = "Basic";
            String acceptValue = "*/*";
            ArrayList<ColumnAdditionByFetchingURLsOperation.HttpHeader> headers = new ArrayList<ColumnAdditionByFetchingURLsOperation.HttpHeader>();
            headers.add(new ColumnAdditionByFetchingURLsOperation.HttpHeader("authorization", authorizationValue));
            headers.add(new ColumnAdditionByFetchingURLsOperation.HttpHeader("user-agent", userAgentValue));
            headers.add(new ColumnAdditionByFetchingURLsOperation.HttpHeader("accept", acceptValue));
            server.enqueue(new MockResponse().setBody("first"));
            server.enqueue(new MockResponse().setBody("second"));
            ColumnAdditionByFetchingURLsOperation op = new ColumnAdditionByFetchingURLsOperation(this.engine_config, "fruits", "value", OnError.StoreError, "junk", 1, 50, true, headers);
            this.runAndWait((EngineDependentOperation)op, 3000);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("user-agent"), (String)userAgentValue);
            Assert.assertEquals((String)request.getHeader("authorization"), (String)authorizationValue);
            Assert.assertEquals((String)request.getHeader("accept"), (String)acceptValue);
            server.shutdown();
        }
    }

    @Test
    public void testRetries() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            int i;
            server.start();
            HttpUrl url = server.url("/retries");
            for (i = 0; i < 2; ++i) {
                Row row = new Row(2);
                row.setCell(0, new Cell((Serializable)((Object)("test" + (i + 1))), null));
                this.project.rows.add(row);
            }
            for (i = 0; i < 5; ++i) {
                server.enqueue(new MockResponse().setHeader("Retry-After", (Object)1).setResponseCode(429).setBody(Integer.toString(i, 10)));
            }
            server.enqueue(new MockResponse().setBody("success"));
            ColumnAdditionByFetchingURLsOperation op = new ColumnAdditionByFetchingURLsOperation(this.engine_config, "fruits", "\"" + url + "?city=\"+value", OnError.StoreError, "rand", 1, 100, false, null);
            long start = System.currentTimeMillis();
            this.runAndWait((EngineDependentOperation)op, 4500);
            long elapsed = System.currentTimeMillis() - start;
            Assert.assertTrue((elapsed > 4000L ? 1 : 0) != 0, (String)("Retry-After retries didn't take long enough - elapsed = " + elapsed));
            Assert.assertTrue((boolean)((Row)this.project.rows.get(0)).getCellValue(1).toString().contains("HTTP error 429"), (String)"missing 429 error");
            Assert.assertEquals((String)((Row)this.project.rows.get(1)).getCellValue(1).toString(), (String)"success");
            server.shutdown();
        }
    }

    @Test
    public void testExponentialRetries() throws Exception {
        try (MockWebServer server = new MockWebServer();){
            int i;
            server.start();
            HttpUrl url = server.url("/retries");
            for (i = 0; i < 3; ++i) {
                Row row = new Row(2);
                row.setCell(0, new Cell((Serializable)((Object)("test" + (i + 1))), null));
                this.project.rows.add(row);
            }
            for (i = 0; i < 5; ++i) {
                server.enqueue(new MockResponse().setResponseCode(503).setBody(Integer.toString(i, 10)));
            }
            server.enqueue(new MockResponse().setBody("success"));
            server.enqueue(new MockResponse().setBody("not found").setResponseCode(404));
            ColumnAdditionByFetchingURLsOperation op = new ColumnAdditionByFetchingURLsOperation(this.engine_config, "fruits", "\"" + url + "?city=\"+value", OnError.StoreError, "rand", 1, 100, false, null);
            long start = System.currentTimeMillis();
            this.runAndWait((EngineDependentOperation)op, 2500);
            long elapsed = System.currentTimeMillis() - start;
            Assert.assertTrue((elapsed > 1600L ? 1 : 0) != 0, (String)("Exponential retries didn't take enough time - elapsed = " + elapsed));
            Assert.assertTrue((boolean)((Row)this.project.rows.get(0)).getCellValue(1).toString().contains("HTTP error 503"), (String)"Missing 503 error");
            Assert.assertEquals((String)((Row)this.project.rows.get(1)).getCellValue(1).toString(), (String)"success");
            Assert.assertTrue((boolean)((Row)this.project.rows.get(2)).getCellValue(1).toString().contains("HTTP error 404"), (String)"Missing 404 error");
            server.shutdown();
        }
    }
}

