/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.recon;

import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.StandardReconConfig;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ReconJudgeSimilarCellsOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ReconJudgeSimilarCellsTests
extends RefineTest {
    static final EngineConfig ENGINE_CONFIG = EngineConfig.reconstruct((String)"{\"mode\":\"row-based\"}}");

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"recon-judge-similar-cells", ReconJudgeSimilarCellsOperation.class);
    }

    @Test
    public void serializeReconJudgeSimilarCellsOperation() throws IOException {
        String json = "{\"op\":\"core/recon-judge-similar-cells\",\"description\":\"Mark to create one single new item for all cells containing \\\"foo\\\" in column A\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"columnName\":\"A\",\"similarValue\":\"foo\",\"judgment\":\"new\",\"shareNewTopics\":true}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, ReconJudgeSimilarCellsOperation.class), json);
    }

    @Test
    public void serializeReconJudgeSimilarCellsOperationMatch() throws IOException {
        String json = "{\"op\":\"core/recon-judge-similar-cells\",\"description\":\"Match item Douglas Adams (Q42) for cells containing \\\"foo\\\" in column A\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"columnName\":\"A\",\"similarValue\":\"foo\",\"judgment\":\"matched\",\"match\":{\"id\":\"Q42\",\"name\":\"Douglas Adams\",\"types\":[\"Q5\"],\"score\":85},\"shareNewTopics\":false}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, ReconJudgeSimilarCellsOperation.class), json);
    }

    @Test
    public void testMarkNewTopics() throws Exception {
        Project project = this.createCSVProject("A,B\nfoo,bar\nalpha,beta\n");
        Column column = (Column)project.columnModel.columns.get(0);
        StandardReconConfig config = new StandardReconConfig("http://my.database/recon_service", "http://my.database/entity/", "http://my.database/schema/", null, null, true, Collections.emptyList());
        column.setReconConfig((ReconConfig)config);
        ReconJudgeSimilarCellsOperation op = new ReconJudgeSimilarCellsOperation(ENGINE_CONFIG, "A", "foo", Recon.Judgment.New, null, Boolean.valueOf(true));
        Process process = op.createProcess(project, new Properties());
        process.performImmediate();
        Cell cell = (Cell)((Row)project.rows.get((int)0)).cells.get(0);
        Assert.assertEquals((Object)Recon.Judgment.New, (Object)cell.recon.judgment);
        Assert.assertEquals((String)"http://my.database/entity/", (String)cell.recon.identifierSpace);
        Assert.assertNull((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).recon);
    }
}

