/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.recon;

import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.ReconJob;
import com.google.refine.model.recon.StandardReconConfig;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ReconOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ReconOperationTests
extends RefineTest {
    private String json = "{\"op\":\"core/recon\",\"description\":\"Reconcile cells in column researcher to type Q5\",\"columnName\":\"researcher\",\"config\":{   \"mode\":\"standard-service\",   \"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",   \"identifierSpace\":\"http://www.wikidata.org/entity/\",   \"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",   \"type\":{\"id\":\"Q5\",\"name\":\"human\"},   \"autoMatch\":true,   \"columnDetails\":[],   \"limit\":0},\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]}}";
    private String processJson = "    {\n       \"description\" : \"Reconcile cells in column researcher to type Q5\",\n       \"id\" : %d,\n       \"immediate\" : false,\n       \"onDone\" : [ {\n         \"action\" : \"createFacet\",\n         \"facetConfig\" : {\n           \"columnName\" : \"researcher\",\n           \"expression\" : \"forNonBlank(cell.recon.judgment, v, v, if(isNonBlank(value), \\\"(unreconciled)\\\", \\\"(blank)\\\"))\",\n           \"name\" : \"researcher: judgment\"\n         },\n         \"facetOptions\" : {\n           \"scroll\" : false\n         },\n         \"facetType\" : \"list\"\n       }, {\n         \"action\" : \"createFacet\",\n         \"facetConfig\" : {\n           \"columnName\" : \"researcher\",\n           \"expression\" : \"cell.recon.best.score\",\n           \"mode\" : \"range\",\n           \"name\" : \"researcher: best candidate's score\"\n         },\n         \"facetType\" : \"range\"\n       } ],\n       \"progress\" : 0,\n       \"status\" : \"pending\"\n     }";

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"recon", ReconOperation.class);
        ReconConfig.registerReconConfig((ButterflyModule)this.getCoreModule(), (String)"standard-service", StandardReconConfig.class);
    }

    @Test
    public void serializeReconOperation() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.json, ReconOperation.class), this.json);
    }

    @Test
    public void serializeReconProcess() throws Exception {
        ReconOperation op = (ReconOperation)ParsingUtilities.mapper.readValue(this.json, ReconOperation.class);
        Project project = (Project)Mockito.mock(Project.class);
        Process process = op.createProcess(project, new Properties());
        TestUtils.isSerializedTo(process, String.format(this.processJson, process.hashCode()));
    }

    @Test
    public void testFailingRecon() throws Exception {
        Project project = this.createCSVProject("my recon test project", "column\nvalueA\nvalueB\nvalueC");
        StandardReconConfig reconConfig = (StandardReconConfig)Mockito.mock(StandardReconConfig.class);
        List<Recon> reconList = Arrays.asList(null, null, null);
        ReconJob reconJob = (ReconJob)Mockito.mock(ReconJob.class);
        Mockito.when((Object)reconConfig.batchRecon((List)Mockito.any(), Mockito.anyLong())).thenReturn(reconList);
        Mockito.when((Object)reconConfig.getBatchSize()).thenReturn((Object)10);
        Mockito.when((Object)reconConfig.createJob((Project)Mockito.eq((Object)project), Mockito.anyInt(), (Row)Mockito.any(), (String)Mockito.any(), (Cell)Mockito.any())).thenReturn((Object)reconJob);
        ReconOperation op = new ReconOperation(EngineConfig.reconstruct((String)"{}"), "column", (ReconConfig)reconConfig);
        Process process = op.createProcess(project, new Properties());
        this.runAndWait(project.getProcessManager(), process, 1000);
        Column column = (Column)project.columnModel.columns.get(0);
        Assert.assertNotNull((Object)column.getReconStats());
        Assert.assertEquals((int)column.getReconStats().matchedTopics, (int)0);
        Assert.assertNull((Object)((Row)project.rows.get((int)0)).getCell((int)0).recon);
        Assert.assertNull((Object)((Row)project.rows.get((int)1)).getCell((int)0).recon);
        Assert.assertNull((Object)((Row)project.rows.get((int)2)).getCell((int)0).recon);
    }
}

