/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.recon;

import com.google.refine.RefineTest;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.recon.StandardReconConfig;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ReconUseValuesAsIdentifiersOperation;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ReconUseValuesAsIdsOperationTests
extends RefineTest {
    String json = "{\"op\":\"core/recon-use-values-as-identifiers\",\"description\":\"Use values as reconciliation identifiers in column ids\",\"columnName\":\"ids\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"service\":\"http://localhost:8080/api\",\"identifierSpace\":\"http://test.org/entities/\",\"schemaSpace\":\"http://test.org/schema/\"}";

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"recon-use-values-as-identifiers", ReconUseValuesAsIdentifiersOperation.class);
    }

    @Test
    public void serializeReconUseValuesAsIdentifiersOperation() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.json, ReconUseValuesAsIdentifiersOperation.class), this.json);
    }

    @Test
    public void testUseValuesAsIds() throws Exception {
        Project project = this.createCSVProject("ids,v\nQ343,hello\n,world\nhttp://test.org/entities/Q31,test");
        ReconUseValuesAsIdentifiersOperation op = (ReconUseValuesAsIdentifiersOperation)ParsingUtilities.mapper.readValue(this.json, ReconUseValuesAsIdentifiersOperation.class);
        op.createProcess(project, new Properties()).performImmediate();
        Assert.assertEquals((String)"Q343", (String)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.match.id);
        Assert.assertEquals((String)"http://test.org/entities/", (String)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.identifierSpace);
        Assert.assertNull(((Row)project.rows.get((int)1)).cells.get(0));
        Assert.assertEquals((String)"Q31", (String)((Cell)((Row)project.rows.get((int)2)).cells.get((int)0)).recon.match.id);
        Assert.assertEquals((int)2, (int)((Column)project.columnModel.columns.get((int)0)).getReconStats().matchedTopics);
        Assert.assertEquals((String)"http://test.org/schema/", (String)((StandardReconConfig)((Column)project.columnModel.columns.get((int)0)).getReconConfig()).schemaSpace);
    }
}

