/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.row;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.row.RowReorderOperation;
import com.google.refine.process.Process;
import com.google.refine.sorting.SortingConfig;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.Serializable;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class RowReorderOperationTests
extends RefineTest {
    Project project = null;

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"row-reorder", RowReorderOperation.class);
    }

    @BeforeMethod
    public void setUp() {
        this.project = this.createCSVProject("key,first\n8,b\n,d\n2,f\n1,h\n");
    }

    @AfterMethod
    public void tearDown() {
        ProjectManager.singleton.deleteProject(this.project.id);
    }

    @Test
    public void testSortEmptyString() throws Exception {
        String sortingJson = "{\"criteria\":[{\"column\":\"key\",\"valueType\":\"number\",\"reverse\":false,\"blankPosition\":2,\"errorPosition\":1}]}";
        SortingConfig sortingConfig = SortingConfig.reconstruct((String)sortingJson);
        ((Row)this.project.rows.get((int)1)).cells.set(0, new Cell((Serializable)((Object)""), null));
        RowReorderOperation op = new RowReorderOperation(Engine.Mode.RowBased, sortingConfig);
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"h", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value);
        Assert.assertEquals((Object)"f", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value);
        Assert.assertEquals((Object)"b", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)1)).value);
        Assert.assertEquals((Object)"d", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)1)).value);
    }

    @Test
    public void serializeRowReorderOperation() throws Exception {
        String json = "  {\n    \"op\": \"core/row-reorder\",\n    \"description\": \"Reorder rows\",\n    \"mode\": \"record-based\",\n    \"sorting\": {\n      \"criteria\": [\n        {\n          \"errorPosition\": 1,\n          \"valueType\": \"number\",\n          \"column\": \"start_year\",\n          \"blankPosition\": 2,\n          \"reverse\": false\n        }\n      ]\n    }\n  }";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, RowReorderOperation.class), json);
    }
}

