/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.process;

import com.google.refine.process.LongRunningProcessTests;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessManagerTests {
    ProcessManager processManager;
    Process process1;
    Process process2;

    @BeforeMethod
    public void setUp() {
        this.processManager = new ProcessManager();
        this.process1 = new LongRunningProcessTests.LongRunningProcessStub("some description");
        this.process2 = new LongRunningProcessTests.LongRunningProcessStub("some other description");
    }

    @Test
    public void serializeProcessManager() throws Exception {
        this.processManager.queueProcess(this.process1);
        this.processManager.queueProcess(this.process2);
        this.processManager.onFailedProcess(this.process1, (Exception)new IllegalArgumentException("unexpected error"));
        for (int total = 0; this.processManager.hasPending() && total < 1000; total += 100) {
            Thread.sleep(100L);
        }
        String processJson = ParsingUtilities.defaultWriter.writeValueAsString((Object)this.process2);
        TestUtils.isSerializedTo(this.processManager, "{\"processes\":[" + processJson + "],\n\"exceptions\":[{\"message\":\"unexpected error\"}]}");
    }
}

