/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.facets.RangeFacet;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.Serializable;
import org.testng.annotations.Test;

public class RangeFacetTests
extends RefineTest {
    public static String configJson = "{\n          \"selectNumeric\": true,\n          \"expression\": \"value\",\n          \"selectBlank\": true,\n          \"selectNonNumeric\": true,\n          \"selectError\": true,\n          \"name\": \"my column\",\n          \"from\": -30,\n          \"to\": 90,\n          \"type\": \"range\",\n          \"columnName\": \"my column\"\n        }";
    public static String facetJson = "{\"name\":\"my column\",\"expression\":\"value\",\"columnName\":\"my column\",\"min\":-50,\"max\":90,\"step\":10,\"bins\":[1,0,0,0,0,1,0,0,0,0,0,0,0,1],\"baseBins\":[1,0,0,0,0,1,0,0,0,0,0,0,0,1],\"from\":-30,\"to\":90,\"baseNumericCount\":3,\"baseNonNumericCount\":1,\"baseBlankCount\":0,\"baseErrorCount\":0,\"numericCount\":3,\"nonNumericCount\":1,\"blankCount\":0,\"errorCount\":0}";

    @Test
    public void serializeRangeFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        RangeFacet.RangeFacetConfig config = (RangeFacet.RangeFacetConfig)ParsingUtilities.mapper.readValue(configJson, RangeFacet.RangeFacetConfig.class);
        TestUtils.isSerializedTo(config, configJson);
    }

    @Test
    public void serializeRangeFacet() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createProject(new String[]{"my column"}, new Serializable[][]{{Double.valueOf(89.2)}, {Double.valueOf(-45.9)}, {"blah"}, {Double.valueOf(0.4)}});
        Engine engine = new Engine(project);
        RangeFacet.RangeFacetConfig config = (RangeFacet.RangeFacetConfig)ParsingUtilities.mapper.readValue(configJson, RangeFacet.RangeFacetConfig.class);
        RangeFacet facet = config.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        TestUtils.isSerializedTo(facet, facetJson);
    }
}

