/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.commands.Command;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.commands.expr.LogExpressionCommand;
import com.google.refine.model.Project;
import com.google.refine.model.ProjectStub;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.preference.TopList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LogExpressionCommandTests
extends CommandTestBase {
    private static long PROJECT_ID = 1234L;
    ProjectManager projectManager = null;
    Project project = null;
    PreferenceStore prefStore;

    @BeforeMethod
    public void setUpCommand() {
        this.command = new LogExpressionCommand();
        ProjectMetadata metadata = new ProjectMetadata();
        ProjectManager.singleton = this.projectManager = new ProjectManagerStub();
        this.project = new ProjectStub(PROJECT_ID);
        ProjectManager.singleton.registerProject(this.project, metadata);
        this.prefStore = ProjectManager.singleton.getPreferenceStore();
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(PROJECT_ID));
    }

    @Test
    public void testCSRFProtection() throws ServletException, IOException {
        this.command.doPost(this.request, this.response);
        this.assertCSRFCheckFailed();
    }

    @Test
    public void testNullExpressions() throws ServletException, IOException {
        this.prefStore.put("scripting.expressions", null);
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(PROJECT_ID));
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value+'a'");
        this.command.doPost(this.request, this.response);
        TopList globalExpressions = (TopList)this.prefStore.get("scripting.expressions");
        Assert.assertEquals((Collection)globalExpressions.getList(), Collections.singletonList("grel:value+'a'"));
        TopList localExpressions = (TopList)this.project.getMetadata().getPreferenceStore().get("scripting.expressions");
        Assert.assertEquals((Iterable)localExpressions, Collections.singletonList("grel:value+'a'"));
    }
}

