/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.google.refine.commands.Command;
import com.google.refine.commands.expr.ExpressionCommandTestBase;
import com.google.refine.commands.expr.ToggleStarredExpressionCommand;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ToggleStarredExpressionCommandTests
extends ExpressionCommandTestBase {
    @BeforeMethod
    public void setUp() {
        this.command = new ToggleStarredExpressionCommand();
    }

    @Test
    public void testJsonResponse() throws ServletException, IOException {
        this.initWorkspace("{\n        \"class\": \"com.google.refine.preference.TopList\",\n        \"top\": 100,\n        \"list\": [\n          \"grel:facetCount(value, 'value', 'Column 1')\",\n          \"grel:facetCount(value, 'value', 'Column 3')\",\n          \"grel:cell.recon.match.id\"]}", "{\n        \"class\": \"com.google.refine.preference.TopList\",\n        \"top\": 100,\n        \"list\": [\n          \"grel:cell.recon.match.id\"\n]}", "{\n        \"class\": \"com.google.refine.preference.TopList\",\n        \"top\": 100,\n        \"list\": [\n          \"grel:value\"\n]}");
        String json = "{\n       \"expressions\" : [ {\n         \"code\" : \"grel:facetCount(value, 'value', 'Column 1')\"\n       }, {\n         \"code\" : \"grel:cell.recon.match.id\"\n       } ]\n     }";
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:facetCount(value, 'value', 'Column 1')");
        Mockito.when((Object)this.request.getParameter("returnList")).thenReturn((Object)"yes");
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        this.command.doPost(this.request, this.response);
        this.assertResponseJsonIs(json);
    }

    @Test
    public void testCSRFProtection() throws ServletException, IOException {
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), "{\"code\":\"error\",\"message\":\"Missing or invalid csrf_token parameter\"}");
    }
}

