/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.StreamExporter;
import com.google.refine.exporters.XlsExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Properties;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class XlsxExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "xlsx exporter test project";
    ByteArrayOutputStream stream;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    StreamExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new XlsExporter(true);
        this.stream = new ByteArrayOutputStream();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.stream = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void getContentType() {
        Assert.assertEquals((String)this.SUT.getContentType(), (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    @Test
    public void getSpreadsheetVersion() {
        XlsExporter exporter = (XlsExporter)this.SUT;
        Assert.assertEquals((Object)exporter.getSpreadsheetVersion(), (Object)SpreadsheetVersion.EXCEL2007);
    }

    @Test
    public void exportSimpleXlsx() {
        this.CreateGrid(2, 2);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.stream.toByteArray());
        try {
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)inStream);
            XSSFSheet ws = wb.getSheetAt(0);
            XSSFRow row1 = ws.getRow(1);
            XSSFCell cell0 = row1.getCell(0);
            Assert.assertEquals((String)cell0.toString(), (String)"row0cell0");
            wb.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void exportXlsxDateType() throws IOException {
        OffsetDateTime odt = OffsetDateTime.parse("2019-04-09T12:00+00:00");
        this.createDateGrid(2, 2, odt);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.stream.toByteArray());
        try {
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)inStream);
            XSSFSheet ws = wb.getSheetAt(0);
            XSSFRow row1 = ws.getRow(1);
            XSSFCell cell0 = row1.getCell(0);
            Assert.assertTrue((boolean)cell0.toString().contains("2019"));
            wb.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void exportXlsxStringWithURLs() throws IOException {
        String url = "GET /primo-library/,http:%2F%2Fcatalogue.unice.fr HTTP/1.1";
        this.createDateGrid(2, 2, (Serializable)((Object)url));
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.stream.toByteArray());
        try {
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)inStream);
            XSSFSheet ws = wb.getSheetAt(0);
            XSSFRow row1 = ws.getRow(1);
            XSSFCell cell0 = row1.getCell(0);
            Assert.assertTrue((boolean)cell0.toString().contains("primo-library"));
            wb.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void test257Columns() throws IOException {
        this.CreateGrid(2, 257);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try (XSSFWorkbook wb = new XSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            XSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(256);
            Assert.assertEquals((String)cell0.toString(), (String)"row0cell256");
        }
    }

    @Test
    public void test10000Columns() throws IOException {
        this.CreateGrid(2, 10000);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try (XSSFWorkbook wb = new XSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            XSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(9999);
            Assert.assertEquals((String)cell0.toString(), (String)"row0cell9999");
        }
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    private void createDateGrid(int noOfRows, int noOfColumns, Serializable value) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell(value, null));
            }
            this.project.rows.add(row);
        }
    }
}

