/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.optimaize.langdetect.i18n.LdLocale;
import java.util.Map;
import org.junit.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DetectLanguageTest
extends RefineTest {
    String functionName;

    @Override
    @BeforeTest
    public void init() {
        this.functionName = "detectLanguage";
    }

    @Test
    public void testDetectLanguage() {
        Map<String, LdLocale> samples = Map.of("I am very sure this works", LdLocale.fromString((String)"en"), "Je suis tr\u00e8s s\u00fbr que cela fonctionne", LdLocale.fromString((String)"fr"), "Estoy muy seguro de que esto funciona", LdLocale.fromString((String)"es"), "Ich bin sehr sicher dass dies funktioniert", LdLocale.fromString((String)"de"));
        samples.forEach((s, ldLocale) -> {
            Assert.assertEquals((Object)DetectLanguageTest.invoke(this.functionName, s), (Object)ldLocale.getLanguage());
            Assert.assertTrue((boolean)(DetectLanguageTest.invoke(this.functionName, s) instanceof String));
        });
    }

    @Test
    public void testDetectLanguageInvalidParams() {
        Assert.assertTrue((boolean)(DetectLanguageTest.invoke(this.functionName, new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(DetectLanguageTest.invoke(this.functionName, "Estoy muy seguro de que esto funciona", "Ich bin sehr sicher dass dies funktioniert") instanceof EvalError));
    }
}

