/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class DiffTests
extends RefineTest {
    static Properties bindings;
    private OffsetDateTime odt1;
    private OffsetDateTime odt2;
    private OffsetDateTime odt3;
    private OffsetDateTime odt4;
    private OffsetDateTime odt5;
    private OffsetDateTime odt6;
    private OffsetDateTime odt7;
    private OffsetDateTime odt8;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.odt1 = OffsetDateTime.parse("2011-09-01T10:15:30.123456+01:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.odt2 = OffsetDateTime.parse("2011-12-02T10:16:30.123467+01:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.odt3 = OffsetDateTime.of(2010, 1, 10, 12, 0, 0, 0, ZoneOffset.UTC);
        this.odt4 = OffsetDateTime.of(2999, 1, 10, 12, 0, 0, 0, ZoneOffset.UTC);
        this.odt5 = OffsetDateTime.of(2285, 1, 1, 12, 0, 0, 0, ZoneOffset.UTC);
        this.odt6 = OffsetDateTime.of(1700, 1, 10, 12, 0, 0, 0, ZoneOffset.UTC);
        this.odt7 = OffsetDateTime.of(1923, 4, 19, 12, 0, 0, 0, ZoneOffset.UTC);
        this.odt8 = OffsetDateTime.of(1923, 4, 21, 12, 0, 0, 0, ZoneOffset.UTC);
    }

    @Test
    public void testDiffInvalidParams() {
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", "one", "two", "three") instanceof EvalError));
    }

    @Test
    public void testDiffString() {
        Assert.assertEquals((String)((String)DiffTests.invoke("diff", "onetwo", "onetwothree")), (String)"three");
    }

    @Test
    public void testDiffOffsetDateTime() {
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt3, "years"), (Object)1L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "days"), (Object)92L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "weeks"), (Object)13L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "months"), (Object)3L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "hours"), (Object)2208L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "minutes"), (Object)132481L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "seconds"), (Object)7948860L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "milliseconds"), (Object)7948860000L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt2, this.odt1, "nanos"), (Object)7948860000011000L);
    }

    @Test
    public void testDiffOffsetDateTimeEvalErrors() {
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", this.odt3, this.odt4, "nanos") instanceof EvalError));
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", this.odt4, this.odt5, "nanos") instanceof EvalError));
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt3, this.odt4, "milliseconds"), (Object)-31209840000000L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt4, this.odt5, "milliseconds"), (Object)22532428800000L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt3, this.odt4, "days"), (Object)-361225L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt4, this.odt5, "days"), (Object)260792L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt6, this.odt7, "days"), (Object)-81547L);
        Assert.assertEquals((Object)DiffTests.invoke("diff", this.odt6, this.odt8, "days"), (Object)-81549L);
    }

    @Test
    public void testDiffOffsetDateTimeEvalErrorsForIncorrectTimeUnit() {
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", this.odt4, this.odt5, "milis") instanceof EvalError));
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", this.odt4, this.odt5, "millis") instanceof EvalError));
        Assert.assertTrue((boolean)(DiffTests.invoke("diff", this.odt4, this.odt5, "yars") instanceof EvalError));
    }
}

