/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FingerprintTests
extends RefineTest {
    static Properties bindings;
    private static final String[][] testStrings;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testInvalidParams() {
        Assert.assertNull((Object)FingerprintTests.invoke("fingerprint", new Object[0]));
        Assert.assertNull((Object)FingerprintTests.invoke("fingerprint", "one", "two", "three"));
        Assert.assertNull((Object)FingerprintTests.invoke("fingerprint", Long.getLong("1")));
    }

    @Test
    public void testNormalize() {
        for (String[] ss : testStrings) {
            Assert.assertEquals((int)ss.length, (int)2, (String)"Invalid test");
            Assert.assertEquals((String)((String)FingerprintTests.invoke("fingerprint", ss[0])), (String)ss[1], (String)("Fingerprint for string: " + ss[0] + " failed"));
        }
    }

    static {
        testStrings = new String[][]{{"sch\u00f6n", "schon"}, {"\tABC \t DEF ", "abc def"}, {"bbb\taaa", "aaa bbb"}, {"m\u00fcller", "muller"}, {"", ""}};
    }
}

