/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RangeTests
extends RefineTest {
    private static final Integer[] EMPTY_ARRAY = new Integer[0];
    private static final Integer[] ONE_AND_THREE = new Integer[]{1, 3};
    private static final Integer[] FIVE_AND_THREE = new Integer[]{5, 3};
    private static final Integer[] ZERO_TO_TWO = new Integer[]{0, 1, 2};
    private static final Integer[] ONE_TO_FOUR = new Integer[]{1, 2, 3, 4};
    private static final Integer[] FIVE_TO_TWO = new Integer[]{5, 4, 3, 2};
    private static final Integer[] NEGATIVE_ONE_TO_FOUR = new Integer[]{-1, 0, 1, 2, 3, 4};
    private static final Integer[] ONE_TO_NEGATIVE_FOUR = new Integer[]{1, 0, -1, -2, -3, -4};

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testRangeInvalidParams() {
        Assert.assertTrue((boolean)(RangeTests.invoke("range", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1, 2, 3, 4") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1, 2, 3", "4") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "2, 3, 4") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1, 2", "3", "4") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1, 2, 3, 4) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "null") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "a") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1,") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", ",") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", ",2") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1.5") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", ",12.3, 2") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1,", "2") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "2,") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1.5", "3") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "3.5") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "1", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "2", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "1", "2") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1,", "2", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "2,", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "2", "1,") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1.5", "3", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "3.5", "1") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "1", "3,", "1.5") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1.2) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1.2, 4.5) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1.2, 5, 3) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1, "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", 1) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1, "a") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "a", 1) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1, "", "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", 1, "") instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", "", "", 1) instanceof EvalError));
        Assert.assertTrue((boolean)(RangeTests.invoke("range", 1.5, "2", 1) instanceof EvalError));
    }

    @Test
    public void testRangeValidSingleStringParams() {
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "3")), (Object[])ZERO_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", " 3  ")), (Object[])ZERO_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5, 1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "   1   ,5")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1,      5     ")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 1, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 1, 1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5, -1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5, 1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5, 2")), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5, 1, -2")), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5, 1, -1")), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5, 1, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5, 1, 1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  1  , 5, 1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1,  5  ,1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5,   1  ")), (Object[])ONE_TO_FOUR);
    }

    @Test
    public void testRangeValidDoubleStringParams() {
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "2", "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "1")), (Object[])new Integer[]{-1, 0});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "5")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  -1   ", "1")), (Object[])new Integer[]{-1, 0});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", " 5  ")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5, -1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5, 1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5, 1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5, -1")), (Object[])ONE_TO_NEGATIVE_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5, 2")), (Object[])new Integer[]{-1, 1, 3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5, -2")), (Object[])new Integer[]{1, -1, -3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5, 10")), (Object[])new Integer[]{-1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5, -10")), (Object[])new Integer[]{1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, -5", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, -5", "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", "1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, -5", "-1")), (Object[])ONE_TO_NEGATIVE_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", "2")), (Object[])new Integer[]{-1, 1, 3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, -5", "-2")), (Object[])new Integer[]{1, -1, -3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", "10")), (Object[])new Integer[]{-1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, -5", "-10")), (Object[])new Integer[]{1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  -1  , 5", "1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1,   5", "1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5", " 1   ")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  -1  ", "5, 1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "  5  , 1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  -1  ", "5,    1   ")), (Object[])NEGATIVE_ONE_TO_FOUR);
    }

    @Test
    public void testRangeValidTripleStringParams() {
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5", "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5", "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5", "1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5", "-1")), (Object[])ONE_TO_NEGATIVE_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5", "2")), (Object[])new Integer[]{-1, 1, 3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5", "-2")), (Object[])new Integer[]{1, -1, -3});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1", "5", "10")), (Object[])new Integer[]{-1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "-5", "-10")), (Object[])new Integer[]{1});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "  -1  , 5, 1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1,   5  , 1")), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "-1, 5,   1   ")), (Object[])NEGATIVE_ONE_TO_FOUR);
    }

    @Test
    public void testRangeValidIntegerParams() {
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5)), (Object[])new Integer[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", -1, 5)), (Object[])NEGATIVE_ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, -1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, 1)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, 2)), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, -2)), (Object[])FIVE_AND_THREE);
    }

    @Test
    public void testRangeValidMixedParams() {
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5", -1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5", 1)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1, 5", 2)), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5, -1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5, 0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5, 1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5, 2")), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, -1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, 1)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, 2)), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, -1)), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, -2)), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", -1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", 1)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", 2)), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", -1)), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", -2)), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, "1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, 5, "2")), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, "-1")), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, 1, "-2")), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "5", -1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "5", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "5", 1)), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", "5", 2)), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", "1", 1)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", "1", 0)), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", "1", -1)), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", "1", -2)), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, "1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "1", 5, "2")), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, "-1")), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", "5", 1, "-2")), (Object[])FIVE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", "-1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", "1")), (Object[])ONE_TO_FOUR);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 1, "5", "2")), (Object[])ONE_AND_THREE);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", "1")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", "0")), (Object[])EMPTY_ARRAY);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", "-1")), (Object[])FIVE_TO_TWO);
        Assert.assertEquals((Object[])((Integer[])RangeTests.invoke("range", 5, "1", "-2")), (Object[])FIVE_AND_THREE);
    }
}

