/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SmartSplitTests {
    private static Properties bindings;

    @BeforeTest
    public void setUp() {
        bindings = new Properties();
    }

    @AfterTest
    public void tearDown() {
        bindings = null;
    }

    @Test
    public void testSmartSplitInvalidParams() {
        Assert.assertTrue((boolean)(SmartSplitTests.invoke("smartSplit", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(SmartSplitTests.invoke("smartSplit", "teststring1", 1, "teststring2", 2) instanceof EvalError));
    }

    @Test
    public void testSmartSplitGuessComma() {
        String testString = "teststring1,teststring2,teststring3,teststring4";
        Object[] expected = new String[]{"teststring1", "teststring2", "teststring3", "teststring4"};
        Object[] actual = (String[])SmartSplitTests.invoke("smartSplit", testString);
        Assert.assertEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testSmartSplitGuessTab() {
        String testString = "teststring1\tteststring2\tteststring3\tteststring4";
        Object[] expected = new String[]{"teststring1", "teststring2", "teststring3", "teststring4"};
        Object[] actual = (String[])SmartSplitTests.invoke("smartSplit", testString);
        Assert.assertEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testSmartSplitCharSepGiven() {
        String testString = "teststring1#teststring2#teststring3#teststring4";
        Object[] expected = new String[]{"teststring1", "teststring2", "teststring3", "teststring4"};
        Object[] actual = (String[])SmartSplitTests.invoke("smartSplit", testString, Character.valueOf('#'));
        Assert.assertEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testSmartSplitCharSepSpace() {
        String testString = "teststring1 teststring2 teststring3 teststring4";
        Object[] expected = new String[]{"teststring1", "teststring2", "teststring3", "teststring4"};
        Object[] actual = (String[])SmartSplitTests.invoke("smartSplit", testString, Character.valueOf(' '));
        Assert.assertEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testSmartSplitStringSepGiven() {
        String testString = "teststring1#@$teststring2#@$teststring3#@$teststring4";
        Object[] expected = new String[]{"teststring1", "teststring2", "teststring3", "teststring4"};
        Object[] actual = (String[])SmartSplitTests.invoke("smartSplit", testString, "#@$");
        Assert.assertEquals((Object[])expected, (Object[])actual);
    }

    private static Object invoke(String name, Object ... args) {
        Function function = ControlFunctionRegistry.getFunction((String)name);
        if (function == null) {
            throw new IllegalArgumentException("Unknown function " + name);
        }
        if (args == null) {
            return function.call(bindings, new Object[0]);
        }
        return function.call(bindings, args);
    }
}

