/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.xml;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ParseXmlTests
extends RefineTest {
    static Properties bindings;
    static String x;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testParseXml() {
        Assert.assertTrue((boolean)(ParseXmlTests.invoke("parseXml", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(ParseXmlTests.invoke("parseXml", "x") instanceof Document));
        Assert.assertTrue((boolean)(ParseXmlTests.invoke("select", Jsoup.parse((String)x, (String)"", (Parser)Parser.xmlParser()), "foaf|Person") instanceof Elements));
        Assert.assertEquals((Object)ParseXmlTests.invoke("innerXml", Jsoup.parse((String)x, (String)"", (Parser)Parser.xmlParser()).select("foaf|Person").first()), (Object)"<foaf:name>John Doe</foaf:name>\n<head>head1</head>\n<head>head2</head>\n<BODY>body1</BODY>\n<foaf:homepage rdf:resource=\"http://www.example.com\" />");
        Assert.assertEquals((Object)ParseXmlTests.invoke("xmlAttr", Jsoup.parse((String)x, (String)"", (Parser)Parser.xmlParser()).select("foaf|homepage").first(), "rdf:resource"), (Object)"http://www.example.com");
        Assert.assertEquals((Object)ParseXmlTests.invoke("ownText", Jsoup.parse((String)x, (String)"", (Parser)Parser.xmlParser()).select("BODY").first()), (Object)"body1");
        Assert.assertEquals((Object)ParseXmlTests.invoke("xmlText", Jsoup.parse((String)x, (String)"", (Parser)Parser.xmlParser()).select("foaf|Person").first()), (Object)"John Doe head1 head2 body1");
    }

    static {
        x = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root xmlns:foaf=\"http://xmlns.com/foaf/0.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n    <foaf:Person>\n        <foaf:name>John Doe</foaf:name>\n        <head>head1</head>\n        <head>head2</head>\n        <BODY>body1</BODY>\n        <foaf:homepage rdf:resource=\"http://www.example.com\"/>\n    </foaf:Person>\n    <foaf:Person>\n        <foaf:name>H\u00e9lo\u00efse Dupont</foaf:name>\n        <head>head3</head>\n        <BODY>body2</BODY>\n        <foaf:title/>\n    </foaf:Person>\n</root>";
    }
}

