/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.controls.ForRange;
import com.google.refine.util.TestUtils;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForRangeTests
extends RefineTest {
    @Test
    public void serializeForRange() {
        String json = "{\"description\":\"Iterates over the variable v starting at \\\"from\\\", incrementing by \\\"step\\\" each time while less than \\\"to\\\". At each iteration, evaluates expression e, and pushes the result onto the result array.\",\"params\":\"number from, number to, number step, variable v, expression e\",\"returns\":\"array\"}";
        TestUtils.isSerializedTo(new ForRange(), json);
    }

    @Test
    public void testForRangeWithPositiveIncrement() throws ParsingException {
        String[] test = new String[]{"forRange(0,6,1,v,v).join(',')", "0,1,2,3,4,5"};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForRangeWithNegativeIncrement() throws ParsingException {
        String[] test = new String[]{"forRange(6,0,-1,v,v).join(',')", "6,5,4,3,2,1"};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForRangeWithSameStartAndEndValues() throws ParsingException {
        String[] test = new String[]{"forRange(10,10,1,v,v).join(',')", ""};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForRangeWithFloatingPointValues() throws ParsingException {
        String expectedResult = String.join((CharSequence)",", Arrays.asList(0.0, 0.1, 0.2, 0.3, 0.4, 0.5).stream().map(v -> String.format("%.3f", v)).collect(Collectors.toList()));
        String[] test = new String[]{"forRange(0,0.6,0.1,v,v.toString('%.3f')).join(',')", expectedResult};
        bindings = new Properties();
        bindings.put("v", "");
        this.parseEval(bindings, test);
    }

    @Test
    public void testForRangeWithImpossibleStep() {
        String[] tests = new String[]{"forRange(0,10,-1,v,v).join(',')", "forRange(10,0,1,v,v).join(',')"};
        bindings = new Properties();
        bindings.put("v", "");
        for (String test : tests) {
            try {
                Evaluable eval = MetaParser.parse((String)("grel:" + test));
                Object result = eval.evaluate(bindings);
                Assert.assertEquals((String)result.toString(), (String)"", (String)("Wrong result for expression: " + test));
            }
            catch (ParsingException e) {
                Assert.fail((String)("Unexpected parse failure: " + test));
            }
        }
    }

    @Test
    public void testForRangeWithStepBiggerThanRange() {
        String[] tests = new String[]{"forRange(0,10,15,v,v).join(',')"};
        bindings = new Properties();
        bindings.put("v", "");
        for (String test : tests) {
            try {
                Evaluable eval = MetaParser.parse((String)("grel:" + test));
                Object result = eval.evaluate(bindings);
                Assert.assertEquals((String)result.toString(), (String)"0", (String)("Wrong result for expression: " + test));
            }
            catch (ParsingException e) {
                Assert.fail((String)("Unexpected parse failure: " + test));
            }
        }
    }

    @Test
    public void testEvalError() {
        String[] tests = new String[]{"forRange(test,0,1,v,v)", "forRange(0,test,1,v,v)", "forRange(10,0,test,v,v)", "forRange(10,0,0,v,v)"};
        bindings = new Properties();
        bindings.put("v", "");
        for (String test : tests) {
            try {
                Evaluable eval = MetaParser.parse((String)("grel:" + test));
                Object result = eval.evaluate(bindings);
                Assert.assertTrue((boolean)(result instanceof EvalError));
            }
            catch (ParsingException e) {
                Assert.fail((String)("Unexpected parse failure: " + test));
            }
        }
    }
}

