/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.google.refine.RefineTest;
import com.google.refine.history.HistoryEntry;
import com.google.refine.io.FileHistoryEntryManager;
import com.google.refine.model.Project;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.column.ColumnAdditionOperation;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FileHistoryEntryManagerTests
extends RefineTest {
    Project project;
    FileHistoryEntryManager sut = new FileHistoryEntryManager();

    @BeforeMethod
    public void setUp() {
        this.project = (Project)Mockito.mock(Project.class);
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"column-addition", ColumnAdditionOperation.class);
    }

    @Test
    public void testWriteHistoryEntry() throws IOException {
        StringWriter writer = new StringWriter();
        HistoryEntry historyEntry = HistoryEntry.load((Project)this.project, (String)"{\"id\":1533633623158,\"description\":\"Create new column uri based on column country by filling 269 rows with grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",\"time\":\"2018-08-07T09:06:37Z\",\"operation\":{\"op\":\"core/column-addition\",   \"description\":\"Create column uri at index 2 based on column country using expression grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},   \"newColumnName\":\"uri\",   \"columnInsertIndex\":2,   \"baseColumnName\":\"country\",   \"expression\":\"grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"onError\":\"set-to-blank\"}}");
        Properties options = new Properties();
        options.setProperty("mode", "save");
        this.sut.save(historyEntry, (Writer)writer, options);
        TestUtils.equalAsJson("{\"id\":1533633623158,\"description\":\"Create new column uri based on column country by filling 269 rows with grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",\"time\":\"2018-08-07T09:06:37Z\",\"operation\":{\"op\":\"core/column-addition\",   \"description\":\"Create column uri at index 2 based on column country using expression grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},   \"newColumnName\":\"uri\",   \"columnInsertIndex\":2,   \"baseColumnName\":\"country\",   \"expression\":\"grel:\\\"https://www.wikidata.org/wiki/\\\"+cell.recon.match.id\",   \"onError\":\"set-to-blank\"}}", writer.toString());
    }
}

