/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.history;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.history.Change;
import com.google.refine.history.History;
import com.google.refine.history.HistoryEntry;
import com.google.refine.history.HistoryEntryManager;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class HistoryTests
extends RefineTest {
    History SUT;
    Project proj;
    ProjectMetadata projectMetadata;
    ProjectManager projectManager;
    HistoryEntryManager historyEntryManager;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.historyEntryManager = (HistoryEntryManager)Mockito.mock(HistoryEntryManager.class);
        ProjectManager.singleton = this.projectManager;
        this.proj = new Project();
        this.projectMetadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        Mockito.when((Object)this.projectManager.getProject(Mockito.anyLong())).thenReturn((Object)this.proj);
        Mockito.when((Object)this.projectManager.getProjectMetadata(Mockito.anyLong())).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectManager.getHistoryEntryManager()).thenReturn((Object)this.historyEntryManager);
        this.SUT = new History(this.proj);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.proj = null;
    }

    @Test
    public void canAddEntry() {
        HistoryEntry entry = (HistoryEntry)Mockito.mock(HistoryEntry.class);
        this.SUT.addEntry(entry);
        ((ProjectManager)Mockito.verify((Object)this.projectManager, (VerificationMode)Mockito.atLeastOnce())).getProject(Mockito.anyLong());
        ((HistoryEntry)Mockito.verify((Object)entry, (VerificationMode)Mockito.times((int)1))).apply(this.proj);
        ((ProjectMetadata)Mockito.verify((Object)this.projectMetadata, (VerificationMode)Mockito.atLeastOnce())).setRowCount(0);
        ((ProjectMetadata)Mockito.verify((Object)this.projectMetadata, (VerificationMode)Mockito.atLeastOnce())).updateModified();
        Assert.assertEquals(this.SUT.getLastPastEntries(1).get(0), (Object)entry);
    }

    @Test
    public void serializeHistory() throws Exception {
        String json1 = "{\"id\":1533650900300,\"description\":\"Reconcile cells in column organization_name to type Q43229\",\"time\":\"2018-08-07T13:57:17Z\",\"operation\":{    \"op\":\"core/recon\",    \"description\":\"Reconcile cells in column organization_name to type Q43229\",    \"columnName\":\"organization_name\",    \"config\":{        \"mode\":\"standard-service\",        \"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",        \"identifierSpace\":\"http://www.wikidata.org/entity/\",        \"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",        \"type\":{\"id\":\"Q43229\",\"name\":\"organization\"},        \"autoMatch\":true,        \"columnDetails\":[],        \"limit\":0},\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]}}}";
        String json1simple = "{\"id\":1533650900300,\"description\":\"Reconcile cells in column organization_name to type Q43229\",\"time\":\"2018-08-07T13:57:17Z\"}";
        String json2 = "{\"id\":1533651586483,\"description\":\"Edit single cell on row 94, column organization_id\",\"time\":\"2018-08-07T14:18:21Z\"}";
        String targetJson = "{\"past\":[" + json1simple + "," + json2 + "],\"future\":[]}";
        Change dummyChange = (Change)Mockito.mock(Change.class);
        HistoryEntry firstEntry = HistoryEntry.load((Project)this.proj, (String)json1);
        firstEntry.setChange(dummyChange);
        HistoryEntry secondEntry = HistoryEntry.load((Project)this.proj, (String)json2);
        secondEntry.setChange(dummyChange);
        this.SUT.addEntry(firstEntry);
        this.SUT.addEntry(secondEntry);
        TestUtils.isSerializedTo(this.SUT, targetJson);
    }
}

