/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ExcelImporter;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ExcelImporterTests
extends ImporterTest {
    private static final double EPSILON = 1.0E-7;
    private static final int SHEETS = 3;
    private static final int ROWS = 4;
    private static final int COLUMNS = 13;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String LEADING_ZERO_FORMAT = "0000";
    private static final String INTEGER_FORMAT = "#,###";
    private static final String CURRENCY_FORMAT = "$#,###.00";
    private static final String FLOAT_FORMAT = "###.00%";
    private static final String OTHER_FORMAT = "###\\-####;\\(###\\)\\ ###\\-####";
    private static final LocalDateTime NOW = LocalDateTime.now();
    private static final String NOW_STRING = NOW.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
    private static final File xlsFile = ExcelImporterTests.createSpreadsheet(false, NOW);
    private static final File xlsxFile = ExcelImporterTests.createSpreadsheet(true, NOW);
    private static final File xlsFileWithMultiSheets = ExcelImporterTests.createSheetsWithDifferentColumns(false);
    private static final File xlsxFileWithMultiSheets = ExcelImporterTests.createSheetsWithDifferentColumns(true);
    ExcelImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new ExcelImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readXls() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsFile);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)13);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)), (String)"Cell value is not a date");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(6), (Object)1L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(6), (Object)2L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(7), (Object)1L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(7), (Object)2L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(8), (Object)1.0);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(8), (Object)2.0);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(9), (Object)"0001");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(9), (Object)"0002");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(10), (Object)"(617) 235-1322");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(11), (Object)NOW_STRING.substring(0, 10));
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(12), (Object)1234.56);
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readXlsx() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsxFile);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)13);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)));
        Assert.assertTrue((Duration.between(NOW, (OffsetDateTime)((Row)this.project.rows.get(1)).getCellValue(3)).toMillis() < 1L ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((Row)this.project.rows.get(1)).getCellValue(5));
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(6), (Object)1L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(6), (Object)2L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(7), (Object)1L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(7), (Object)2L);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(8), (Object)1.0);
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(8), (Object)2.0);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(9), (Object)"0001");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(9), (Object)"0002");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(10), (Object)"(617) 235-1322");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(11), (Object)NOW_STRING.substring(0, 10));
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(12), (Object)1234.56);
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readXlsxAsText() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        ExcelImporterTests.whenGetBooleanOption("forceText", this.options, true);
        FileInputStream stream = new FileInputStream(xlsxFile);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)13);
        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.getDefault());
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(0)), (String)numberFormat.format(1.1));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(2)).getCellValue(0)), (String)numberFormat.format(2.2));
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(1)), (String)"FALSE");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(2)).getCellValue(1)), (String)"TRUE");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(3)), (String)NOW_STRING);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(5)), (String)"");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(6)), (String)"1");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(2)).getCellValue(6)), (String)"2");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(7), (Object)"1");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(7), (Object)"2");
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.getDefault());
        decimalFormat.applyPattern("0.00");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(8), (Object)(decimalFormat.format(100.0) + "%"));
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(8), (Object)(decimalFormat.format(200.0) + "%"));
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(9), (Object)"0001");
        Assert.assertEquals((Object)((Row)this.project.rows.get(2)).getCellValue(9), (Object)"0002");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(10), (Object)"(617) 235-1322");
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(11), (Object)NOW_STRING.substring(0, 10));
        Assert.assertEquals((Object)((Row)this.project.rows.get(3)).getCellValue(12), (Object)("$" + numberFormat.format(1234.56)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readExcel95() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("excel95.xls");
        try {
            Assert.assertEquals((int)this.parseOneFileAndReturnExceptions((ImportingParserBase)this.SUT, stream).size(), (int)1);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void readExcelDates() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        InputStream stream = ClassLoader.getSystemResourceAsStream("dates.xls");
        this.parseOneFile((ImportingParserBase)this.SUT, stream);
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(0), (Object)"2021-04-18");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(0), (Object)"2021-01-01");
    }

    @Test
    public void readMultiSheetXls() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 1\", fileNameAndSheetIndex: \"file-source#1\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 2\", fileNameAndSheetIndex: \"file-source#2\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsFileWithMultiSheets);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)12);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)13);
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)15);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(4)).getCellValue(0)).doubleValue(), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(4)).getCellValue(13)).doubleValue(), (double)1.0, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)), (String)"Cell value is not a date");
        Assert.assertTrue((Duration.between(NOW, (OffsetDateTime)((Row)this.project.rows.get(1)).getCellValue(3)).toMillis() < 1L ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void readMultiSheetXlsx() throws IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 1\", fileNameAndSheetIndex: \"file-source#1\", rows: 31, selected: true}"));
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 2\", fileNameAndSheetIndex: \"file-source#2\", rows: 31, selected: true}"));
        ExcelImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        ExcelImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        ExcelImporterTests.whenGetIntegerOption("limit", this.options, -1);
        ExcelImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        FileInputStream stream = new FileInputStream(xlsxFileWithMultiSheets);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)12);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)13);
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)15);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(1)).getCellValue(0)).doubleValue(), (double)1.1, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(2)).getCellValue(0)).doubleValue(), (double)2.2, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(4)).getCellValue(0)).doubleValue(), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((double)((Number)((Row)this.project.rows.get(4)).getCellValue(13)).doubleValue(), (double)1.0, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(1)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(2)).getCellValue(1)));
        Assert.assertTrue((boolean)ParsingUtilities.isDate((Object)((Row)this.project.rows.get(1)).getCellValue(3)), (String)"Cell value is not a date");
        Assert.assertTrue((Duration.between(NOW, (OffsetDateTime)((Row)this.project.rows.get(1)).getCellValue(3)).toMillis() < 1L ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(4)), (String)" Row 1 Col 5");
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(1)).getCellValue(5)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)3))).get("storeBlankCellsAsNulls");
    }

    private static File createSpreadsheet(boolean xml, LocalDateTime date) {
        File file;
        XSSFWorkbook wb = xml ? new XSSFWorkbook() : new HSSFWorkbook();
        DataFormat dataFormat = wb.createDataFormat();
        CellStyle dateTimeStyle = wb.createCellStyle();
        dateTimeStyle.setDataFormat(dataFormat.getFormat(DATE_TIME_FORMAT));
        CellStyle dateStyle = wb.createCellStyle();
        dateStyle.setDataFormat(dataFormat.getFormat(DATE_FORMAT));
        CellStyle intStyle = wb.createCellStyle();
        intStyle.setDataFormat(dataFormat.getFormat(INTEGER_FORMAT));
        CellStyle floatStyle = wb.createCellStyle();
        floatStyle.setDataFormat(dataFormat.getFormat(FLOAT_FORMAT));
        CellStyle zeroStyle = wb.createCellStyle();
        zeroStyle.setDataFormat(dataFormat.getFormat(LEADING_ZERO_FORMAT));
        CellStyle otherStyle = wb.createCellStyle();
        otherStyle.setDataFormat(dataFormat.getFormat(OTHER_FORMAT));
        CellStyle currencyStyle = wb.createCellStyle();
        currencyStyle.setDataFormat(dataFormat.getFormat(CURRENCY_FORMAT));
        for (int s = 0; s < 3; ++s) {
            Sheet sheet = wb.createSheet("Test Sheet " + s);
            for (int row = 0; row < 4; ++row) {
                ExcelImporterTests.createDataRow(sheet, row, date, dateTimeStyle, dateStyle, intStyle, floatStyle, zeroStyle, otherStyle, currencyStyle, 0);
            }
        }
        try {
            file = File.createTempFile("openrefine-importer-test", xml ? ".xlsx" : ".xls");
            file.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(file);
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            wb.close();
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private static File createSheetsWithDifferentColumns(boolean xml) {
        File file;
        XSSFWorkbook wb = xml ? new XSSFWorkbook() : new HSSFWorkbook();
        DataFormat dataFormat = wb.createDataFormat();
        CellStyle dateTimeStyle = wb.createCellStyle();
        dateTimeStyle.setDataFormat(dataFormat.getFormat(DATE_TIME_FORMAT));
        CellStyle dateStyle = wb.createCellStyle();
        dateStyle.setDataFormat(dataFormat.getFormat(DATE_FORMAT));
        CellStyle intStyle = wb.createCellStyle();
        intStyle.setDataFormat(dataFormat.getFormat(INTEGER_FORMAT));
        CellStyle floatStyle = wb.createCellStyle();
        floatStyle.setDataFormat(dataFormat.getFormat(FLOAT_FORMAT));
        CellStyle zeroStyle = wb.createCellStyle();
        zeroStyle.setDataFormat(dataFormat.getFormat(LEADING_ZERO_FORMAT));
        CellStyle otherStyle = wb.createCellStyle();
        otherStyle.setDataFormat(dataFormat.getFormat(OTHER_FORMAT));
        CellStyle currencyStyle = wb.createCellStyle();
        currencyStyle.setDataFormat(dataFormat.getFormat(CURRENCY_FORMAT));
        for (int s = 0; s < 3; ++s) {
            Sheet sheet = wb.createSheet("Test Sheet " + s);
            for (int row = 0; row < 4; ++row) {
                ExcelImporterTests.createDataRow(sheet, row, NOW, dateTimeStyle, dateStyle, intStyle, floatStyle, zeroStyle, otherStyle, currencyStyle, s);
            }
        }
        try {
            file = File.createTempFile("openrefine-importer-test", xml ? ".xlsx" : ".xls");
            file.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(file);
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            ((OutputStream)outputStream).close();
            wb.close();
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private static void createDataRow(Sheet sheet, int row, LocalDateTime date, CellStyle dateTimeStyle, CellStyle dateStyle, CellStyle intStyle, CellStyle floatStyle, CellStyle zeroStyle, CellStyle otherStyle, CellStyle currencyStyle, int extra_columns) {
        int col = 0;
        org.apache.poi.ss.usermodel.Row r = sheet.createRow(row);
        Cell c = r.createCell(col++);
        c.setCellValue((double)row * 1.1);
        c = r.createCell(col++);
        c.setCellValue(row % 2 == 0);
        int n = ++col;
        c = r.createCell(n);
        c.setCellValue(date);
        c.setCellStyle(dateTimeStyle);
        int n2 = ++col;
        c = r.createCell(n2);
        c.setCellValue(" Row " + row + " Col " + ++col);
        c = r.createCell(col++);
        c.setCellValue("");
        c = r.createCell(col++);
        c.setCellValue((double)row);
        c = r.createCell(col++);
        c.setCellValue((double)row * 1.1);
        c.setCellStyle(intStyle);
        c = r.createCell(col++);
        c.setCellValue((double)row);
        c.setCellStyle(floatStyle);
        c = r.createCell(col++);
        c.setCellValue((double)row);
        c.setCellStyle(zeroStyle);
        c = r.createCell(col++);
        c.setCellValue(6.172351322E9);
        c.setCellStyle(otherStyle);
        c = r.createCell(col++);
        c.setCellValue(date);
        c.setCellStyle(dateStyle);
        c = r.createCell(col++);
        c.setCellValue(1234.56);
        c.setCellStyle(currencyStyle);
        for (int i = 0; i < extra_columns; ++i) {
            c = r.createCell(col++);
            c.setCellValue((double)(i + extra_columns));
        }
    }
}

