/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineServlet;
import com.google.refine.RefineServletStub;
import com.google.refine.RefineTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.TreeImportingParserBase;
import com.google.refine.importers.tree.XmlImportUtilities;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mockito.Mockito;
import org.testng.Assert;

public abstract class ImporterTest
extends RefineTest {
    protected Project project;
    protected ProjectMetadata metadata;
    protected ImportingJob job;
    protected RefineServlet servlet;
    protected ObjectNode options;

    public void setUp() {
        this.servlet = new RefineServletStub();
        ImportingManager.initialize((RefineServlet)this.servlet);
        this.project = new Project();
        this.metadata = new ProjectMetadata();
        ImportingJob spiedJob = ImportingManager.createJob();
        this.job = (ImportingJob)Mockito.spy((Object)spiedJob);
        Mockito.when((Object)this.job.getRetrievalRecord()).thenReturn((Object)ParsingUtilities.mapper.createObjectNode());
        this.options = (ObjectNode)Mockito.mock(ObjectNode.class);
    }

    public void tearDown() {
        this.project = null;
        this.metadata = null;
        ImportingManager.disposeJob((long)this.job.id);
        this.job = null;
        this.options = null;
    }

    protected void parseOneFile(ImportingParserBase parser, Reader reader) {
        ArrayList exceptions = new ArrayList();
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", reader, -1, this.options, exceptions);
        Assert.assertEquals((int)exceptions.size(), (int)0);
        this.project.update();
    }

    protected void parseOneFile(ImportingParserBase parser, InputStream inputStream) {
        ArrayList exceptions = new ArrayList();
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", inputStream, -1, this.options, exceptions);
        Assert.assertEquals((int)exceptions.size(), (int)0);
        this.project.update();
    }

    protected List<Exception> parseOneFileAndReturnExceptions(ImportingParserBase parser, InputStream inputStream) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", inputStream, -1, this.options, exceptions);
        this.project.update();
        return exceptions;
    }

    protected void parseOneFile(TreeImportingParserBase parser, Reader reader) {
        ImportColumnGroup rootColumnGroup = new ImportColumnGroup();
        ArrayList exceptions = new ArrayList();
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", reader, rootColumnGroup, -1, this.options, exceptions);
        Assert.assertEquals((int)exceptions.size(), (int)0);
        XmlImportUtilities.createColumnsFromImport((Project)this.project, (ImportColumnGroup)rootColumnGroup);
        this.project.columnModel.update();
    }

    protected void parseOneFile(TreeImportingParserBase parser, InputStream inputStream, ObjectNode options) {
        this.parseOneInputStreamAsReader(parser, inputStream, options);
    }

    protected void parseOneInputStream(TreeImportingParserBase parser, InputStream inputStream, ObjectNode options) {
        ImportColumnGroup rootColumnGroup = new ImportColumnGroup();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", inputStream, rootColumnGroup, -1, options, exceptions);
        this.postProcessProject(this.project, rootColumnGroup, exceptions);
    }

    protected void parseOneInputStreamAsReader(TreeImportingParserBase parser, InputStream inputStream, ObjectNode options) {
        ImportColumnGroup rootColumnGroup = new ImportColumnGroup();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        InputStreamReader reader = new InputStreamReader(inputStream);
        parser.parseOneFile(this.project, this.metadata, this.job, "file-source", (Reader)reader, rootColumnGroup, -1, options, exceptions);
        this.postProcessProject(this.project, rootColumnGroup, exceptions);
        try {
            ((Reader)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void postProcessProject(Project project, ImportColumnGroup rootColumnGroup, List<Exception> exceptions) {
        XmlImportUtilities.createColumnsFromImport((Project)project, (ImportColumnGroup)rootColumnGroup);
        project.update();
        for (Exception e : exceptions) {
            e.printStackTrace();
        }
        Assert.assertEquals((int)exceptions.size(), (int)0);
    }
}

