/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.MarcImporter;
import com.google.refine.importers.XmlImporterTests;
import com.google.refine.importers.tree.TreeImportingParserBase;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class MarcImporterTests
extends XmlImporterTests {
    MarcImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new MarcImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readMarcFileWithUnicode() throws FileNotFoundException, IOException {
        String FILE = "scriblio.mrc";
        String filename = ClassLoader.getSystemResource("scriblio.mrc").getPath();
        FileUtils.copyFile((File)new File(filename), (File)new File(this.job.getRawDataDir(), "scriblio.mrc"));
        ArrayList<ObjectNode> fileRecords = new ArrayList<ObjectNode>();
        fileRecords.add(ParsingUtilities.evaluateJsonStringToObjectNode((String)String.format("{\"location\": \"%s\"}", "scriblio.mrc")));
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, fileRecords, "binary/marc");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"marc:collection");
        JSONUtilities.append((ArrayNode)path, (String)"marc:record");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        JSONUtilities.safePut((ObjectNode)options, (String)"trimStrings", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"storeEmptyStrings", (boolean)false);
        File xmlFile = ImportingUtilities.getFile((ImportingJob)this.job, (ObjectNode)((ObjectNode)fileRecords.get(0)));
        FileInputStream inputStream = new FileInputStream(xmlFile);
        this.parseOneFile((TreeImportingParserBase)this.SUT, inputStream, options);
        Assert.assertEquals((int)this.project.rows.size(), (int)30);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)6);
        Row r0 = (Row)this.project.rows.get(0);
        Assert.assertEquals((Object)r0.getCellValue(1), (Object)"001");
        Assert.assertEquals((Object)r0.getCellValue(3), (Object)"010");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(1), (Object)"003");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(2), (Object)"DLC");
        Row r2 = (Row)this.project.rows.get(2);
        Assert.assertEquals((Object)r2.getCellValue(1), (Object)"005");
        Assert.assertEquals((Object)r2.getCellValue(5), (Object)"\u00a34.99");
        Assert.assertEquals((Object)((Row)this.project.rows.get(29)).getCellValue(3), (Object)"700");
    }
}

