/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.RdfTripleImporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RdfTripleImporterTests
extends ImporterTest {
    RdfTripleImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new RdfTripleImporter();
        JSONUtilities.safePut((ObjectNode)this.options, (String)"base-url", (String)"http://rdf.mybase.com");
    }

    @Test(enabled=false)
    public void canParseSingleLineTriple() {
        String sampleRdf = "<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.blood_on_the_tracks>.";
        StringReader reader = new StringReader(sampleRdf);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)reader);
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.assertColumnNamesMatch(this.project, new String[]{"subject", "http://rdf.mybase.com/ns/music.artist.album"});
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)2);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://rdf.mybase.com/ns/en.bob_dylan");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.blood_on_the_tracks");
    }

    @Test
    public void canParseMultiLineTriple() throws UnsupportedEncodingException {
        String sampleRdf = "<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.blood_on_the_tracks>.\n<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.under_the_red_sky>.\n<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.bringing_it_all_back_home>.";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://rdf.mybase.com/ns/music.artist.album"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)3);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://rdf.mybase.com/ns/en.bob_dylan");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.bringing_it_all_back_home");
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)2);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(0));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.under_the_red_sky");
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)1).cellDependencies[1].rowIndex, (int)0);
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)1).cellDependencies[1].cellIndex, (int)0);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)2)).cells.size(), (int)2);
        Assert.assertNull(((Row)this.project.rows.get((int)2)).cells.get(0));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.blood_on_the_tracks");
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)2).cellDependencies[1].rowIndex, (int)0);
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)2).cellDependencies[1].cellIndex, (int)0);
    }

    @Test
    public void canParseMultiLineMultiPredicatesTriple() throws UnsupportedEncodingException {
        String sampleRdf = "<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.blood_on_the_tracks>.\n<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.genre> <http://rdf.mybase.com/ns/en.folk_rock>.\n<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/music.artist.album> <http://rdf.mybase.com/ns/en.bringing_it_all_back_home>.";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://rdf.mybase.com/ns/music.artist.album", "http://rdf.mybase.com/ns/music.artist.genre"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://rdf.mybase.com/ns/en.bob_dylan");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.bringing_it_all_back_home");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"http://rdf.mybase.com/ns/en.folk_rock");
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)2);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(0));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"http://rdf.mybase.com/ns/en.blood_on_the_tracks");
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)1).cellDependencies[1].rowIndex, (int)0);
        Assert.assertEquals((int)this.project.recordModel.getRowDependency((int)1).cellDependencies[1].cellIndex, (int)0);
    }

    @Test
    public void canParseTripleWithValue() throws UnsupportedEncodingException {
        String sampleRdf = "<http://rdf.mybase.com/ns/en.bob_dylan> <http://rdf.mybase.com/ns/common.topic.alias>\"Robert Zimmerman\"@en.";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.N3);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://rdf.mybase.com/ns/common.topic.alias"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://rdf.mybase.com/ns/en.bob_dylan");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"Robert Zimmerman@en");
    }

    @Test
    public void canParseRdfXml() throws UnsupportedEncodingException {
        String sampleRdf = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n         xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <rdf:Description rdf:about=\"http://www.w3.org/TR/rdf-syntax-grammar\">\n    <dc:title>RDF/XML Syntax Specification (Revised)</dc:title>\n    <dc:title xml:lang=\"en\">RDF/XML Syntax Specification (Revised)</dc:title>\n    <dc:title xml:lang=\"en-US\">RDF/XML Syntax Specification (Revised)</dc:title>\n  </rdf:Description>\n\n  <rdf:Description rdf:about=\"http://example.org/buecher/baum\" xml:lang=\"de\">\n    <dc:title>Der Baum</dc:title>\n    <dc:description>Das Buch ist au\u00dfergew\u00f6hnlich</dc:description>\n    <dc:title xml:lang=\"en\">The Tree</dc:title>\n  </rdf:Description>\n</rdf:RDF>\n";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.RDFXML);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://purl.org/dc/elements/1.1/title", "http://purl.org/dc/elements/1.1/description"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)5);
        for (Row row : this.project.rows) {
            if (row.cells.size() != 3) continue;
            Assert.assertEquals((Object)((Cell)row.cells.get((int)0)).value, (Object)"http://example.org/buecher/baum");
            Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)"The Tree@en");
            Assert.assertEquals((Object)((Cell)row.cells.get((int)2)).value, (Object)"Das Buch ist au\u00dfergew\u00f6hnlich@de");
        }
    }

    @Test
    public void canParseN3() throws UnsupportedEncodingException {
        String sampleRdf = "@prefix p:  <http://www.example.org/personal_details#> .\n@prefix m:  <http://www.example.org/meeting_organization#> .\n\n<http://www.example.org/people#fred>\np:GivenName     \"Fred\";\np:hasEmail              <mailto:fred@example.com>;\nm:attending     <http://meetings.example.com/cal#m1> .\n";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.N3);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://www.example.org/meeting_organization#attending", "http://www.example.org/personal_details#hasEmail", "http://www.example.org/personal_details#GivenName"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://www.example.org/people#fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"http://meetings.example.com/cal#m1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"mailto:fred@example.com");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value, (Object)"Fred");
    }

    @Test
    public void canParseTtl() throws UnsupportedEncodingException {
        String sampleRdf = "@prefix p:  <http://www.example.org/personal_details#> .\n@prefix m:  <http://www.example.org/meeting_organization#> .\n\n<http://www.example.org/people#fred>\np:GivenName     \"Fred\";\np:hasEmail              <mailto:fred@example.com>;\nm:attending     <http://meetings.example.com/cal#m1> .\n";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.TTL);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://www.example.org/meeting_organization#attending", "http://www.example.org/personal_details#hasEmail", "http://www.example.org/personal_details#GivenName"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://www.example.org/people#fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"http://meetings.example.com/cal#m1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"mailto:fred@example.com");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value, (Object)"Fred");
    }

    @Test
    public void canParseNTriples() throws UnsupportedEncodingException {
        String sampleRdf = "<http://www.example.org/people#fred> <http://www.example.org/meeting_organization#attending> <http://meetings.example.com/cal#m1> . \n<http://www.example.org/people#fred> <http://www.example.org/personal_details#hasEmail> <mailto:fred@example.com> . \n<http://www.example.org/people#fred> <http://www.example.org/personal_details#GivenName> \"Fred\" . ";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.NT);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://www.example.org/personal_details#GivenName", "http://www.example.org/personal_details#hasEmail", "http://www.example.org/meeting_organization#attending"};
        this.assertColumnNamesMatch(this.project, columns);
        String[][] gridValues = new String[][]{{"http://www.example.org/people#fred", "Fred", "mailto:fred@example.com", "http://meetings.example.com/cal#m1"}};
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://www.example.org/people#fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"Fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"mailto:fred@example.com");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value, (Object)"http://meetings.example.com/cal#m1");
    }

    @Test
    public void canParseTurtleBlankNode() throws UnsupportedEncodingException {
        String sampleRdf = "@prefix ex: <http://example.org/data#> .\n<http://example.org/web-data> ex:title \"Web Data\" ;\n                               ex:professor [ ex:fullName \"Alice Carol\" ;\n                                              ex:homePage <http://example.net/alice-carol> ] .";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleRdf.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.TTL);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://example.org/data#professor", "http://example.org/data#title", "http://example.org/data#homePage", "http://example.org/data#fullName"};
        this.assertColumnNamesMatchUnordered(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)5);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"http://example.org/web-data");
        int profColumn = this.project.columnModel.getColumnNames().indexOf("http://example.org/data#professor");
        int subjColumn = this.project.columnModel.getColumnNames().indexOf("subject");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)subjColumn)).value, (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)profColumn)).value);
    }

    private void assertColumnNamesMatch(Project project, String[] columns) {
        this.assertColumnNamesMatch(project, columns, false);
    }

    private void assertColumnNamesMatchUnordered(Project project, String[] columns) {
        this.assertColumnNamesMatch(project, columns, true);
    }

    private void assertColumnNamesMatch(Project project, String[] columns, boolean sortNames) {
        Object[] projectColumns = project.columnModel.getColumnNames().toArray(new String[columns.length]);
        if (sortNames) {
            Arrays.sort(columns);
            Arrays.sort(projectColumns);
        }
        Assert.assertTrue((boolean)Arrays.deepEquals(projectColumns, columns));
    }

    @Test
    public void canParseJsonld() throws UnsupportedEncodingException {
        String sampleJsonld = "{\n   \"@context\": {\n     \"m\": \"http://www.example.org/meeting_organization#\",\n     \"p\": \"http://www.example.org/personal_details#\",\n     \"rdf\": \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\",\n     \"rdfs\": \"http://www.w3.org/2000/01/rdf-schema#\",\n     \"xsd\": \"http://www.w3.org/2001/XMLSchema#\"\n   },\n   \"@id\": \"http://www.example.org/people#fred\",\n   \"m:attending\": {\n     \"@id\": \"http://meetings.example.com/cal#m1\"\n   },\n   \"p:GivenName\": \"Fred\",\n   \"p:hasEmail\": {\n     \"@id\": \"mailto:fred@example.com\"\n   }\n }";
        ByteArrayInputStream input = new ByteArrayInputStream(sampleJsonld.getBytes("UTF-8"));
        this.SUT = new RdfTripleImporter(RdfTripleImporter.Mode.JSONLD);
        this.parseOneFile((ImportingParserBase)this.SUT, input);
        String[] columns = new String[]{"subject", "http://www.example.org/personal_details#hasEmail", "http://www.example.org/personal_details#GivenName", "http://www.example.org/meeting_organization#attending"};
        this.assertColumnNamesMatch(this.project, columns);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"http://www.example.org/people#fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"mailto:fred@example.com");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"Fred");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value, (Object)"http://meetings.example.com/cal#m1");
    }
}

