/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.SeparatorBasedImporter;
import com.google.refine.messages.OpenRefineMessage;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SeparatorBasedImporterTests
extends ImporterTest {
    String SAMPLE_ROW = "NDB_No,Shrt_Desc,Water";
    SeparatorBasedImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new SeparatorBasedImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readJustColumns(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSimpleData_CSV_1Header_1Row(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\ndata1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSimpleData_CSV_1Header_1Row_GuessValues(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\ndata1" + inputSeparator + "234" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, true, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertTrue((boolean)(((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value instanceof Long));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)Long.parseLong("234"));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSimpleData_0Header_1Row(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "data1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 1"));
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 2"));
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 3"));
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readDoesNotTrimLeadingTrailingWhitespace(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1 " + inputSeparator + " 3.4 " + inputSeparator + " data3 ";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)" data1 ");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)" 3.4 ");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)" data3 ");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readDoesNotTrimLeadingWhitespace(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1" + inputSeparator + " 12" + inputSeparator + " data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, true, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)" data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)12L);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)" data3");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readTrimsLeadingTrailingWhitespaceOnTrimStrings(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1 " + inputSeparator + " 3.4 " + inputSeparator + " data3 ";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, false, false, true);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"3.4");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readDoesNotTrimLeadingTrailingWhitespaceOnNoTrimStrings(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1 " + inputSeparator + " 3.4 " + inputSeparator + " data3 ";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, false, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)" data1 ");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)" 3.4 ");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)" data3 ");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void trimAndAutodetectDatatype(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1 " + inputSeparator + " 3.4 " + inputSeparator + " data3 ";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, true, false, true);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)Double.parseDouble("3.4"));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readCanAddNull(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = " data1" + inputSeparator + inputSeparator + " data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, true, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)" data1");
        Assert.assertNull(((Row)this.project.rows.get((int)0)).cells.get(1));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)" data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSimpleData_2Header_1Row(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\nsub1" + inputSeparator + "sub2" + inputSeparator + "sub3\ndata1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 0, 0, 2, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1 sub1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2 sub2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3 sub3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSimpleData_RowLongerThanHeader(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\ndata1" + inputSeparator + "data2" + inputSeparator + "data3" + inputSeparator + "data4" + inputSeparator + "data5" + inputSeparator + "data6";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)6);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(3)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 4"));
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(4)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 5"));
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(5)).getName(), (String)(OpenRefineMessage.importer_utilities_column() + " 6"));
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)6);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value, (Object)"data4");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)4)).value, (Object)"data5");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)5)).value, (Object)"data6");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readQuotedData(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\n\"\"\"To Be\"\" is often followed by \"\"or not To Be\"\"\"" + inputSeparator + "data2";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"\"To Be\" is often followed by \"or not To Be\"");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readIgnoreFirstLine(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "ignore1\ncol1" + inputSeparator + "col2" + inputSeparator + "col3\ndata1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 0, 1, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readSkipFirstDataLine(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\nskip1\ndata1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 1, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readIgnore3_Header2_Skip1(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "ignore1\nignore2\nignore3\ncol1" + inputSeparator + "col2" + inputSeparator + "col3\nsub1" + inputSeparator + "sub2" + inputSeparator + "sub3\nskip1\ndata1" + inputSeparator + "data2" + inputSeparator + "data3";
        try {
            this.prepareOptions(sep, -1, 1, 3, 2, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1 sub1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2 sub2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3 sub3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readIgnore3_Header2_Skip2_limit2(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "ignore1\nignore2\nignore3\ncol1" + inputSeparator + "col2" + inputSeparator + "col3\nsub1" + inputSeparator + "sub2" + inputSeparator + "sub3\nskip1\nskip2\ndata-row1-cell1" + inputSeparator + "data-row1-cell2" + inputSeparator + "data-row1-cell3\ndata-row2-cell1" + inputSeparator + "data-row2-cell2" + inputSeparator + "\ndata-row3-cell1" + inputSeparator + "data-row3-cell2" + inputSeparator + "data-row1-cell3";
        try {
            this.prepareOptions(sep, 2, 2, 3, 2, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1 sub1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2 sub2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3 sub3");
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data-row1-cell1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data-row1-cell2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data-row1-cell3");
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"data-row2-cell1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"data-row2-cell2");
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(2));
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void ignoreQuotes(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "data1" + inputSeparator + "data2\"" + inputSeparator + "data3" + inputSeparator + "data4";
        try {
            this.prepareOptions(sep, -1, 0, 0, 0, false, true);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)4);
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2\"");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readWithMultiLinedQuotedData(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\n\"\"\"To\n Be\"\" is often followed by \"\"or not To\n Be\"\"\"" + inputSeparator + "data2";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"\"To\n Be\" is often followed by \"or not To\n Be\"");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
    }

    @Test(groups={}, dataProvider="CSV-TSV-AutoDetermine")
    public void readWithMultiLinedQuotedDataAndBlankLines(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "col1" + inputSeparator + "col2" + inputSeparator + "col3\n\"A line with many \n\n\n\n\n empty lines\"" + inputSeparator + "data2";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"A line with many \n\n\n\n\n empty lines");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void customQuoteCharacter(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "'col1'" + inputSeparator + "'col2'" + inputSeparator + "'col3'\n'data1'" + inputSeparator + "'data2'" + inputSeparator + "'data3'";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false, "'");
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test(dataProvider="CSV-TSV-AutoDetermine")
    public void readCustomColumnNames(String sep) {
        String inputSeparator = sep == null ? "\t" : sep;
        String input = "data1" + inputSeparator + "data2" + inputSeparator + "data3\n";
        try {
            this.prepareOptions(sep, -1, 0, 0, 1, false, false, "\"", "[\"col1\",\"col2\",\"col3\"]", false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"col2");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"col3");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"data3");
    }

    @Test
    public void readCsvWithProperties() {
        StringReader reader = new StringReader(this.SAMPLE_ROW);
        this.prepareOptions(",", -1, 0, 0, 0, true, true);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)reader);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value)), (String)"NDB_No");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value)), (String)"Shrt_Desc");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value)), (String)"Water");
    }

    @Test
    public void readCsvWithPropertiesIgnoreQuotes() {
        String input = "data1,data2\",data3,data4";
        StringReader reader = new StringReader(input);
        this.prepareOptions(",", -1, 0, 0, 0, true, true);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)reader);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value)), (String)"data1");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value)), (String)"data2\"");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value)), (String)"data3");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value)), (String)"data4");
    }

    @Test
    public void readTsvWithEmbeddedEscapes() {
        String input = "da\\rta1\tdat\\ta2\tdata3\tdat\\na4";
        StringReader reader = new StringReader(input);
        this.prepareOptions("\t", -1, 0, 0, 0, false, true);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)reader);
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)4);
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value)), (String)"da\rta1");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value)), (String)"dat\ta2");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value)), (String)"data3");
        Assert.assertEquals((String)((String)((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value)), (String)"dat\na4");
    }

    @Test
    public void testThatDefaultGuessIsATabSeparatorAndDefaultProcessQuotesToFalse() {
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, new LinkedList(), "text/json");
        AssertJUnit.assertEquals((String)"\\t", (String)options.get("separator").textValue());
        AssertJUnit.assertFalse((boolean)options.get("processQuotes").asBoolean());
    }

    @Test
    public void testThatSeparatorIsGuessedCorrectlyForCSV() throws IOException {
        List<ObjectNode> fileRecords = this.prepareFileRecords("food.small.csv");
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, fileRecords, "text/csv");
        AssertJUnit.assertEquals((String)",", (String)options.get("separator").textValue());
    }

    @Test
    public void testThatSeparatorIsGuessedCorrectlyForTSVAndDefaultProcessQuotesToFalse() throws IOException {
        List<ObjectNode> fileRecords = this.prepareFileRecords("movies-condensed.tsv");
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, fileRecords, "text/tsv");
        AssertJUnit.assertEquals((String)"\\t", (String)options.get("separator").textValue());
        AssertJUnit.assertFalse((boolean)options.get("processQuotes").asBoolean());
    }

    @DataProvider(name="CSV-TSV-AutoDetermine")
    public Object[][] CSV_TSV_or_AutoDetermine() {
        return new Object[][]{{","}, {"\t"}, {null}};
    }

    protected void prepareOptions(String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes) {
        this.prepareOptions(sep, limit, skip, ignoreLines, headerLines, guessValueType, ignoreQuotes, "\"");
    }

    private void prepareOptions(String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes, String quoteCharacter) {
        this.prepareOptions(sep, limit, skip, ignoreLines, headerLines, guessValueType, ignoreQuotes, quoteCharacter, "[]", false);
    }

    protected void prepareOptions(String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes, boolean trimStrings) {
        SeparatorBasedImporterTests.whenGetStringOption("separator", this.options, sep);
        SeparatorBasedImporterTests.whenGetIntegerOption("limit", this.options, limit);
        SeparatorBasedImporterTests.whenGetIntegerOption("skipDataLines", this.options, skip);
        SeparatorBasedImporterTests.whenGetIntegerOption("ignoreLines", this.options, ignoreLines);
        SeparatorBasedImporterTests.whenGetIntegerOption("headerLines", this.options, headerLines);
        SeparatorBasedImporterTests.whenGetBooleanOption("guessCellValueTypes", this.options, guessValueType);
        SeparatorBasedImporterTests.whenGetBooleanOption("processQuotes", this.options, !ignoreQuotes);
        SeparatorBasedImporterTests.whenGetBooleanOption("trimStrings", this.options, trimStrings);
    }

    protected void prepareOptions(String sep, int limit, int skip, int ignoreLines, int headerLines, boolean guessValueType, boolean ignoreQuotes, String quoteCharacter, String columnNames, boolean includeArchiveFileName) {
        SeparatorBasedImporterTests.whenGetStringOption("separator", this.options, sep);
        SeparatorBasedImporterTests.whenGetStringOption("quoteCharacter", this.options, quoteCharacter);
        SeparatorBasedImporterTests.whenGetIntegerOption("limit", this.options, limit);
        SeparatorBasedImporterTests.whenGetIntegerOption("skipDataLines", this.options, skip);
        SeparatorBasedImporterTests.whenGetIntegerOption("ignoreLines", this.options, ignoreLines);
        SeparatorBasedImporterTests.whenGetIntegerOption("headerLines", this.options, headerLines);
        SeparatorBasedImporterTests.whenGetBooleanOption("guessCellValueTypes", this.options, guessValueType);
        SeparatorBasedImporterTests.whenGetBooleanOption("processQuotes", this.options, !ignoreQuotes);
        SeparatorBasedImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        SeparatorBasedImporterTests.whenGetArrayOption("columnNames", this.options, ParsingUtilities.evaluateJsonStringToArrayNode((String)columnNames));
        SeparatorBasedImporterTests.whenGetBooleanOption("includeArchiveFileName", this.options, includeArchiveFileName);
    }

    private List<ObjectNode> prepareFileRecords(String FILE) throws IOException {
        String filename = ClassLoader.getSystemResource(FILE).getPath();
        FileUtils.copyFile((File)new File(filename), (File)new File(this.job.getRawDataDir(), FILE));
        ArrayList<ObjectNode> fileRecords = new ArrayList<ObjectNode>();
        fileRecords.add(ParsingUtilities.evaluateJsonStringToObjectNode((String)String.format("{\"location\": \"%s\"}", FILE)));
        return fileRecords;
    }
}

