/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.common.io.PatternFilenameFilter;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.TextFormatGuesser;
import com.google.refine.importing.EncodingGuesser;
import com.google.refine.importing.FormatGuesser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TextFormatGuesserTests
extends ImporterTest {
    FormatGuesser guesser;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.guesser = new TextFormatGuesser();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.guesser = null;
        super.tearDown();
    }

    @Test
    public void xlsTextGuessTest() throws FileNotFoundException, IOException {
        String dir = ClassLoader.getSystemResource("Colorado-Municipalities-small-xlsx.gz").getPath();
        GZIPInputStream is = new GZIPInputStream(new FileInputStream(new File(dir)));
        File tmp = File.createTempFile("openrefinetests-textguesser", "");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)tmp);
        String format = this.guesser.guess(tmp, "UTF-8", "text");
        Assert.assertEquals((String)format, (String)"binary");
    }

    @Test
    public void csvGuesserTest() throws IOException {
        this.extensionGuesserTests("csv", "text/line-based");
    }

    @Test
    public void tsvGuesserTest() throws IOException {
        this.extensionGuesserTests("tsv", "text/line-based");
    }

    @Test(enabled=false)
    public void jsonGuesserTest() throws IOException {
        this.extensionGuesserTests("json", "text/json");
    }

    @Test
    public void xmlGuesserTest() throws IOException {
        this.extensionGuesserTests("xml", "text/xml");
    }

    private void extensionGuesserTests(String extension, String expectedFormat) throws IOException {
        String dir = ClassLoader.getSystemResource("food.csv").getPath();
        dir = dir.substring(0, dir.lastIndexOf(47));
        File testDataDir = new File(dir);
        for (String testFile : testDataDir.list((FilenameFilter)new PatternFilenameFilter(".+\\." + extension))) {
            String encoding = EncodingGuesser.guessEncoding((File)testDataDir, (String)testFile);
            String format = this.guesser.guess(new File(dir, testFile), encoding, "text");
            Assert.assertEquals((String)format, (String)expectedFormat, (String)("Format guess failed for " + testFile));
        }
    }

    @Test
    public void guessWikiTable() throws IOException {
        String input = "\n{|\n|-\n| a || b<br/>2 || c \n|-\n| d || e || f<br>\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    private void testWikiTableString(String input) throws IOException, FileNotFoundException {
        File tmp = File.createTempFile("openrefinetests-textguesser", "");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), Charset.forName("UTF-8").newEncoder());
        writer.write(input);
        writer.close();
        String format = this.guesser.guess(tmp, "UTF-8", "text");
        Assert.assertEquals((String)format, (String)"text/wiki");
    }

    @Test
    public void guessTableWithMisplacedHeaders() throws FileNotFoundException, IOException {
        String input = "\n{|\n|-\n| a || b<br/>2 || c \n|-\n| d\n! e\n| f<br>\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void guessTableWithLinks() throws FileNotFoundException, IOException {
        String input = "\n{|\n|-\n| [[Europ\u00e4isches Zentrum f\u00fcr die F\u00f6rderung der Berufsbildung|Cedefop]] || Cedefop || http://www.cedefop.europa.eu/\n|-\n| [[Europ\u00e4ische Stiftung zur Verbesserung der Lebens- und Arbeitsbedingungen]] || EUROFOUND || [http://www.eurofound.europa.eu/]\n|-\n| [[Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht]] || EMCDDA || [http://www.emcdda.europa.eu/ europa.eu]\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void readStyledTableWithHeader() throws FileNotFoundException, IOException {
        String input = "\n==Agenturen==\n{| class=\"wikitable sortable\"\n! style=\"text-align:left; width: 60em\" | Offizieller Name\n! style=\"text-align:left; width: 9em\" | Abk\u00fcrzung\n! style=\"text-align:left; width: 6em\" | Website\n! style=\"text-align:left; width: 15em\" | Standort\n! style=\"text-align:left; width: 18em\" | Staat\n! style=\"text-align:left; width: 6em\" | Gr\u00fcndung\n! style=\"text-align:left; width: 50em\" | Anmerkungen\n|-\n| [[Europ\u00e4isches Zentrum f\u00fcr die F\u00f6rderung der Berufsbildung]] || '''Cedefop''' || [http://www.cedefop.europa.eu/] || [[Thessaloniki]] || {{Griechenland}} || 1975 ||\n|-\n| [[Europ\u00e4ische Stiftung zur Verbesserung der Lebens- und Arbeitsbedingungen]] || ''EUROFOUND'' || [http://www.eurofound.europa.eu/] || [[Dublin]] || {{Irland}} || 1975 ||\n|-\n| [[Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht]] || EMCDDA || [http://www.emcdda.europa.eu/] || [[Lissabon]] || {{Portugal}} || 1993 ||\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void guessTableWithSpanningCells() throws FileNotFoundException, IOException {
        String input = "{| class=\"wikitable\"\n!colspan=\"6\"|Shopping List\n|-\n|Bread & Butter\n|Pie\n|Buns\n|rowspan=\"2\"|Danish\n|colspan=\"2\"|Croissant\n|-\n|Cheese\n|colspan=\"2\"|Ice cream\n|Butter\n|Yogurt\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void guessTableWithReferences() throws FileNotFoundException, IOException {
        String input = "{|\n! price\n! fruit\n! merchant\n|-\n| a || b <ref name=\"myref\"> See [http://gnu.org here]</ref>  || c <ref name=\"ms\"> or http://microsoft.com/ </ref>\n|-\n| d || e <ref name=\"ms\"/>|| f <ref name=\"myref\" />\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void guessTableWithReferencesTemplates() throws FileNotFoundException, IOException {
        String input = "{|\n! price\n! fruit\n! merchant\n|-\n| a || b <ref name=\"myref\">{{cite web|url=http://gnu.org|accessdate=2017-08-30}}</ref>  || c <ref name=\"ms\"> or {{cite journal|url=http://microsoft.com/|title=BLah}} </ref>\n|-\n| d || e <ref name=\"ms\"/>|| f <ref name=\"myref\" />\n|-\n|}\n";
        this.testWikiTableString(input);
    }

    @Test
    public void guessTableWithTemplates() throws FileNotFoundException, IOException {
        String input = "\n{|\n|-\n| {{free to read}} || b || c \n|-\n| d\n| [[File:My logo.svg|70px]]\n| f<br>\n|-\n|}\n";
        this.testWikiTableString(input);
    }
}

