/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.column;

import com.google.refine.RefineTest;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.column.ColumnReorderOperation;
import com.google.refine.process.Process;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ColumnReorderOperationTests
extends RefineTest {
    Project project;

    @BeforeSuite
    public void setUp() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"column-reorder", ColumnReorderOperation.class);
    }

    @BeforeMethod
    public void createProject() {
        this.project = this.createProject(new String[]{"a", "b", "c"}, new Serializable[][]{{"1|2", "d", "e"}, {"3", "f", "g"}});
    }

    @Test
    public void serializeColumnReorderOperation() {
        ColumnReorderOperation op = new ColumnReorderOperation(Arrays.asList("b", "c", "a"));
        TestUtils.isSerializedTo(op, "{\"op\":\"core/column-reorder\",\"description\":\"Reorder columns\",\"columnNames\":[\"b\",\"c\",\"a\"]}");
    }

    @Test
    public void testEraseCellsOnRemovedColumns() throws Exception {
        int aCol = this.project.columnModel.getColumnByName("a").getCellIndex();
        int bCol = this.project.columnModel.getColumnByName("b").getCellIndex();
        int cCol = this.project.columnModel.getColumnByName("c").getCellIndex();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(aCol), (Object)"1|2");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(bCol), (Object)"d");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(cCol), (Object)"e");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(aCol), (Object)"3");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(bCol), (Object)"f");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(cCol), (Object)"g");
        ColumnReorderOperation op = new ColumnReorderOperation(Arrays.asList("a"));
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(aCol), (Object)"1|2");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(bCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCellValue(cCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(aCol), (Object)"3");
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(bCol), null);
        Assert.assertEquals((Object)((Row)this.project.rows.get(1)).getCellValue(cCol), null);
    }
}

