/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.recon;

import com.google.refine.RefineTest;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.StandardReconConfig;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ReconMarkNewTopicsOperation;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ReconMarkNewTopicsOperationTests
extends RefineTest {
    String jsonWithoutService = "{\"op\":\"core/recon-mark-new-topics\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"columnName\":\"my column\",\"shareNewTopics\":true,\"description\":\"Mark to create new items for cells in column my column, one item for each group of similar cells\"}";
    String jsonWithService = "{\"op\":\"core/recon-mark-new-topics\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]},\"columnName\":\"my column\",\"shareNewTopics\":true,\"description\":\"Mark to create new items for cells in column my column, one item for each group of similar cells\",\"service\":\"http://foo.com/api\",\"identifierSpace\":\"http://foo.com/identifierSpace\",\"schemaSpace\":\"http://foo.com/schemaSpace\"}";

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"recon-mark-new-topics", ReconMarkNewTopicsOperation.class);
    }

    @Test
    public void serializeReconMarkNewTopicsOperation() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.jsonWithoutService, ReconMarkNewTopicsOperation.class), this.jsonWithoutService);
    }

    @Test
    public void serializeReconMarkNewTopicsOperationWithService() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.jsonWithService, ReconMarkNewTopicsOperation.class), this.jsonWithService);
    }

    @Test
    public void testNotPreviouslyReconciled() throws Exception {
        Project project = this.createProject(new String[]{"my column"}, new Serializable[][]{{"hello"}, {"world"}});
        ReconMarkNewTopicsOperation op = (ReconMarkNewTopicsOperation)ParsingUtilities.mapper.readValue(this.jsonWithService, ReconMarkNewTopicsOperation.class);
        op.createProcess(project, new Properties()).performImmediate();
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.judgment, (Object)Recon.Judgment.New);
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).recon.judgment, (Object)Recon.Judgment.New);
        Assert.assertEquals((String)"http://foo.com/identifierSpace", (String)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.identifierSpace);
        Assert.assertEquals((String)"http://foo.com/identifierSpace", (String)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).recon.identifierSpace);
        Assert.assertEquals((int)2, (int)((Column)project.columnModel.columns.get((int)0)).getReconStats().newTopics);
        Assert.assertEquals((String)"http://foo.com/schemaSpace", (String)((StandardReconConfig)((Column)project.columnModel.columns.get((int)0)).getReconConfig()).schemaSpace);
    }

    @Test
    public void testPreviouslyReconciled() throws Exception {
        Project project = this.createProject(new String[]{"my column"}, new Serializable[][]{{"hello"}, {"world"}});
        StandardReconConfig reconConfig = new StandardReconConfig("http://foo.com/api", "http://foo.com/identifierSpace", "http://foo.com/schemaSpace", null, false, 10, Collections.emptyList(), 0);
        ((Column)project.columnModel.columns.get(0)).setReconConfig((ReconConfig)reconConfig);
        ReconMarkNewTopicsOperation op = (ReconMarkNewTopicsOperation)ParsingUtilities.mapper.readValue(this.jsonWithoutService, ReconMarkNewTopicsOperation.class);
        op.createProcess(project, new Properties()).performImmediate();
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.judgment, (Object)Recon.Judgment.New);
        Assert.assertEquals((Object)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).recon.judgment, (Object)Recon.Judgment.New);
        Assert.assertEquals((String)"http://foo.com/identifierSpace", (String)((Cell)((Row)project.rows.get((int)0)).cells.get((int)0)).recon.identifierSpace);
        Assert.assertEquals((String)"http://foo.com/identifierSpace", (String)((Cell)((Row)project.rows.get((int)1)).cells.get((int)0)).recon.identifierSpace);
        Assert.assertEquals((int)2, (int)((Column)project.columnModel.columns.get((int)0)).getReconStats().newTopics);
        Assert.assertEquals((String)"http://foo.com/schemaSpace", (String)((StandardReconConfig)((Column)project.columnModel.columns.get((int)0)).getReconConfig()).schemaSpace);
    }
}

