/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.model.Project;
import com.google.refine.model.ProjectStub;
import com.google.refine.model.Row;
import com.google.refine.process.ProcessManager;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ProjectManagerTests
extends RefineTest {
    private static final Instant BASE_DATE = Instant.parse("1970-01-02T00:30:00Z");
    private static final int ROW_COUNT = 3;
    private static final String[] TAGS = new String[]{"testtag1", "testtag2"};
    ProjectManagerStub pm;
    ProjectManagerStub SUT;
    Project project;
    ProjectMetadata metadata;
    ProcessManager procmgr;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws NoSuchFieldException, IllegalAccessException {
        this.pm = new ProjectManagerStub();
        this.SUT = (ProjectManagerStub)((Object)Mockito.spy((Object)((Object)this.pm)));
        this.project = (Project)Mockito.mock(Project.class);
        Field field = Project.class.getDeclaredField("rows");
        field.setAccessible(true);
        field.set(this.project, new ArrayList());
        this.addRows(this.project);
        this.metadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        Mockito.when((Object)this.metadata.getTags()).thenReturn((Object)TAGS);
        this.procmgr = (ProcessManager)Mockito.mock(ProcessManager.class);
        Mockito.when((Object)this.project.getProcessManager()).thenReturn((Object)this.procmgr);
        Mockito.when((Object)this.procmgr.hasPending()).thenReturn((Object)false);
    }

    private void addRows(Project p) {
        for (int i = 0; i < 3; ++i) {
            p.rows.add(new Row(3));
        }
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.metadata = null;
        this.project = null;
        this.SUT = null;
        this.pm = null;
    }

    @Test
    public void canRegisterProject() {
        this.SUT.registerProject(this.project, this.metadata);
        this.AssertProjectRegistered();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata)).setRowCount(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
        AssertJUnit.assertEquals(this.SUT.getAllProjectsTags().keySet(), Set.of(TAGS));
    }

    @Test
    public void canEnsureProjectSave() {
        this.whenGetSaveTimes(this.project, this.metadata);
        this.registerProject();
        this.SUT.ensureProjectSaved(this.project.id);
        this.AssertProjectRegistered();
        try {
            ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveMetadata(this.metadata, this.project.id);
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.verifySaveTimeCompared(1);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveProject(this.project);
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata)).setRowCount(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void canSaveAllModified() {
        this.whenGetSaveTimes(this.project, this.metadata);
        this.registerProject(this.project, this.metadata);
        Project project2 = (Project)Mockito.spy((Object)((Object)new ProjectStub(2L)));
        this.addRows(project2);
        ProjectMetadata metadata2 = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        this.whenGetSaveTimes(project2, metadata2, 10);
        this.registerProject(project2, metadata2);
        Assert.assertNotEquals((Object)project2.id, (Object)this.project.id);
        this.SUT.save(true);
        this.verifySaved(this.project, this.metadata);
        this.verifySaved(project2, metadata2);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    @Test
    public void canFlushFromCache() {
        this.whenGetSaveTimes(this.project, this.metadata, -10);
        this.registerProject(this.project, this.metadata);
        Assert.assertSame((Object)this.SUT.getProject(0L), (Object)this.project);
        this.SUT.save(true);
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.atLeastOnce())).getModified();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.atLeastOnce())).getTags();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata)).setRowCount(3);
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.atLeastOnce())).getProcessManager();
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.atLeastOnce())).getLastSave();
        ((Project)Mockito.verify((Object)this.project, (VerificationMode)Mockito.times((int)1))).dispose();
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveProject(this.project);
        Assert.assertNull((Object)this.SUT.getProject(0L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    @Test
    public void cannotSaveWhenBusy() {
        this.registerProject();
        this.SUT.setBusy(true);
        this.SUT.save(false);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveProjects(Mockito.anyBoolean());
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.never()))).saveWorkspace();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)1))).getTags();
        ((ProjectMetadata)Mockito.verify((Object)this.metadata)).setRowCount(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.project});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void canSaveSomeModified() {
        this.registerProject();
        this.whenGetSaveTimes(this.project, this.metadata);
        this.SUT.save(false);
        this.verifySaved(this.project, this.metadata);
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveWorkspace();
    }

    protected void registerProject() {
        this.registerProject(this.project, this.metadata);
    }

    protected void registerProject(Project proj, ProjectMetadata meta) {
        this.SUT.registerProject(proj, meta);
    }

    protected void AssertProjectRegistered() {
        Assert.assertEquals((Object)this.SUT.getProject(this.project.id), (Object)this.project);
        Assert.assertEquals((Object)this.SUT.getProjectMetadata(this.project.id), (Object)this.metadata);
    }

    protected void whenGetSaveTimes(Project proj, ProjectMetadata meta) {
        this.whenGetSaveTimes(proj, meta, 5);
    }

    protected void whenGetSaveTimes(Project proj, ProjectMetadata meta, int secondsDifference) {
        this.whenProjectGetLastSave(proj);
        this.whenMetadataGetModified(meta, secondsDifference);
    }

    protected void whenProjectGetLastSave(Project proj) {
        Mockito.when((Object)proj.getLastSave()).thenReturn((Object)BASE_DATE);
    }

    protected void whenMetadataGetModified(ProjectMetadata meta, int secondsDifference) {
        Mockito.when((Object)meta.getModified()).thenReturn((Object)BASE_DATE.plusSeconds(secondsDifference));
    }

    protected void verifySaveTimeCompared(int times) {
        this.verifySaveTimeCompared(this.project, this.metadata, times);
    }

    protected void verifySaveTimeCompared(Project project, ProjectMetadata metadata, int times) {
        ((ProjectMetadata)Mockito.verify((Object)metadata, (VerificationMode)Mockito.times((int)times))).getModified();
        ((Project)Mockito.verify((Object)project, (VerificationMode)Mockito.times((int)times))).getLastSave();
    }

    protected void verifySaved(Project proj, ProjectMetadata meta) {
        ((ProjectMetadata)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).getModified();
        ((Project)Mockito.verify((Object)proj, (VerificationMode)Mockito.times((int)2))).getLastSave();
        ((ProjectManagerStub)((Object)Mockito.verify((Object)((Object)this.SUT), (VerificationMode)Mockito.times((int)1)))).saveProject(proj);
        ((ProjectMetadata)Mockito.verify((Object)meta, (VerificationMode)Mockito.times((int)1))).getTags();
        ((ProjectMetadata)Mockito.verify((Object)meta)).setRowCount(3);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{proj});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{meta});
    }
}

