/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing;

import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.util.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EngineConfigTests {
    public static String engineConfigJson = "{\n      \"mode\": \"row-based\",\n      \"facets\": [\n        {\n          \"mode\": \"text\",\n          \"invert\": false,\n          \"caseSensitive\": false,\n          \"query\": \"www\",\n          \"name\": \"reference\",\n          \"type\": \"text\",\n          \"columnName\": \"reference\"\n        }\n      ]\n    }";
    public static String engineConfigRecordModeJson = "{    \"mode\":\"record-based\",    \"facets\":[]}";
    public static String noFacetProvided = "{\"mode\":\"row-based\"}";

    @Test
    public void serializeEngineConfig() {
        EngineConfig ec = EngineConfig.reconstruct((String)engineConfigJson);
        TestUtils.isSerializedTo(ec, engineConfigJson);
    }

    @Test
    public void serializeEngineConfigRecordMode() {
        EngineConfig ec = EngineConfig.reconstruct((String)engineConfigRecordModeJson);
        TestUtils.isSerializedTo(ec, engineConfigRecordModeJson);
    }

    @Test
    public void reconstructNullEngineConfig() {
        EngineConfig ec = EngineConfig.reconstruct(null);
        Assert.assertEquals((Object)ec.getMode(), (Object)Engine.Mode.RowBased);
        Assert.assertTrue((boolean)ec.getFacetConfigs().isEmpty());
    }

    @Test
    public void reconstructNoFacetsProvided() {
        EngineConfig ec = EngineConfig.reconstruct((String)noFacetProvided);
        Assert.assertEquals((Object)ec.getMode(), (Object)Engine.Mode.RowBased);
        Assert.assertTrue((boolean)ec.getFacetConfigs().isEmpty());
    }
}

