/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.RowFilter;
import com.google.refine.browsing.facets.ScatterplotFacet;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.Serializable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScatterplotFacetTests
extends RefineTest {
    public static String configJson = "{\n          \"to_x\": 1,\n          \"to_y\": 1,\n          \"dot\": 1,\n          \"from_x\": 0.21333333333333335,\n          \"l\": 150,\n          \"type\": \"scatterplot\",\n          \"from_y\": 0.26666666666666666,\n          \"dim_y\": \"lin\",\n          \"ex\": \"value\",\n          \"dim_x\": \"lin\",\n          \"ey\": \"value\",\n          \"cx\": \"my column\",\n          \"cy\": \"e\",\n          \"name\": \"my column (x) vs. e (y)\"\n        }";
    public static String facetJson = "{\"name\":\"my column (x) vs. e (y)\",\"cx\":\"my column\",\"ex\":\"value\",\"cy\":\"e\",\"ey\":\"value\",\"l\":150,\"dot\":1,\"r\":0,\"dim_x\":0,\"dim_y\":0,\"color\":\"000000\",\"from_x\":0.21333333333333335,\"to_x\":1,\"from_y\":0.26666666666666666,\"to_y\":1}";

    @Test
    public void serializeScatterplotFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        ScatterplotFacet.ScatterplotFacetConfig config = (ScatterplotFacet.ScatterplotFacetConfig)ParsingUtilities.mapper.readValue(configJson, ScatterplotFacet.ScatterplotFacetConfig.class);
        TestUtils.isSerializedTo(config, configJson);
    }

    @Test
    public void serializeScatterplotFacet() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createProject(new String[]{"my column", "e"}, new Serializable[][]{{Double.valueOf(89.2), Double.valueOf(89.2)}, {Double.valueOf(-45.9), Double.valueOf(-45.9)}, {"blah", "blah"}, {Double.valueOf(0.4), Double.valueOf(0.4)}});
        Engine engine = new Engine(project);
        ScatterplotFacet.ScatterplotFacetConfig config = (ScatterplotFacet.ScatterplotFacetConfig)ParsingUtilities.mapper.readValue(configJson, ScatterplotFacet.ScatterplotFacetConfig.class);
        ScatterplotFacet facet = config.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        TestUtils.isSerializedTo(facet, facetJson);
        RowFilter filter = facet.getRowFilter(project);
        Assert.assertTrue((boolean)filter.filterRow(project, 0, (Row)project.rows.get(0)));
        Assert.assertFalse((boolean)filter.filterRow(project, 1, (Row)project.rows.get(1)));
        Assert.assertTrue((boolean)filter.filterRow(project, 3, (Row)project.rows.get(3)));
    }
}

